/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.stream;

import com.jn.langx.io.stream.ConsumerToInputStreamInterceptorAdapter;
import com.jn.langx.io.stream.ConsumerToOutputStreamInterceptorAdapter;
import com.jn.langx.io.stream.IOStreamInterceptor;
import com.jn.langx.util.Objs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer4;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class IOStreamPipeline {
    private List<IOStreamInterceptor> interceptors = Collects.emptyArrayList();

    public void addFirst(IOStreamInterceptor interceptor) {
        this.interceptors.add(0, interceptor);
    }

    public void addLast(IOStreamInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public void beforeWrite(OutputStream outputStream, byte[] b, int off, int len) {
        if (Objs.isNotEmpty(this.interceptors)) {
            boolean continueExecute = true;
            for (int i = 0; continueExecute && i < this.interceptors.size(); ++i) {
                IOStreamInterceptor interceptor = this.interceptors.get(i);
                continueExecute = interceptor.beforeWrite(outputStream, b, off, len);
            }
        }
    }

    public void afterWrite(OutputStream outputStream, byte[] b, int off, int len) {
        if (Objs.isNotEmpty(this.interceptors)) {
            boolean continueExecute = true;
            for (int i = 0; continueExecute && i < this.interceptors.size(); ++i) {
                IOStreamInterceptor interceptor = this.interceptors.get(i);
                continueExecute = interceptor.afterWrite(outputStream, b, off, len);
            }
        }
    }

    public void beforeRead(InputStream inputStream, byte[] b, int off, int len) {
        if (Objs.isNotEmpty(this.interceptors)) {
            boolean continueExecute = true;
            for (int i = 0; continueExecute && i < this.interceptors.size(); ++i) {
                IOStreamInterceptor interceptor = this.interceptors.get(i);
                continueExecute = interceptor.beforeRead(inputStream, b, off, len);
            }
        }
    }

    public void afterRead(InputStream inputStream, byte[] b, int off, int len) {
        if (Objs.isNotEmpty(this.interceptors)) {
            boolean continueExecute = true;
            for (int i = 0; continueExecute && i < this.interceptors.size(); ++i) {
                IOStreamInterceptor interceptor = this.interceptors.get(i);
                continueExecute = interceptor.afterRead(inputStream, b, off, len);
            }
        }
    }

    public static IOStreamPipeline of(IOStreamInterceptor ... interceptors) {
        return IOStreamPipeline.of(Collects.asList(interceptors));
    }

    public static IOStreamPipeline of(List<? extends IOStreamInterceptor> interceptors) {
        final IOStreamPipeline pipeline = new IOStreamPipeline();
        Collects.forEach(interceptors, new Consumer<IOStreamInterceptor>(){

            @Override
            public void accept(IOStreamInterceptor interceptor) {
                pipeline.addLast(interceptor);
            }
        });
        return pipeline;
    }

    public static IOStreamPipeline ofInputStreamConsumers(List<Consumer4<InputStream, byte[], Integer, Integer>> consumers) {
        return IOStreamPipeline.of(Pipeline.of(consumers).map(ConsumerToInputStreamInterceptorAdapter.consumerToInterceptorMapper).asList());
    }

    public static IOStreamPipeline ofOutputStreamConsumers(List<Consumer4<OutputStream, byte[], Integer, Integer>> consumers) {
        return IOStreamPipeline.of(Pipeline.of(consumers).map(ConsumerToOutputStreamInterceptorAdapter.consumerToInterceptorMapper).asList());
    }
}

