/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.stream;

import com.jn.langx.io.Rewindable;
import com.jn.langx.io.buffer.BigByteBuffer;
import com.jn.langx.io.buffer.BigByteBufferBuilder;
import com.jn.langx.util.Maths;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.io.IOs;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RewindableInputStream
extends FilterInputStream
implements Rewindable<Void> {
    private BigByteBufferBuilder bufferBuilder;
    private BigByteBuffer buffer;
    private volatile boolean closed = false;

    public RewindableInputStream(InputStream in) {
        super(in);
        this.bufferBuilder = new BigByteBufferBuilder();
    }

    public RewindableInputStream(InputStream in, boolean direct, int segmentSize) {
        super(in);
        this.bufferBuilder = new BigByteBufferBuilder().segmentSize(segmentSize).direct(direct);
    }

    public RewindableInputStream(InputStream in, boolean direct, long capacity, int segmentSize) {
        super(in);
        this.bufferBuilder = new BigByteBufferBuilder().capacity(capacity).segmentSize(segmentSize).direct(direct);
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("the stream is closed");
        }
        if (this.buffer == null) {
            this.doRead();
        }
        if (this.buffer.hasRemaining()) {
            return IOs.filterInputStreamRead(this.buffer.get());
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("the stream is closed");
        }
        if (this.buffer == null) {
            this.doRead();
        }
        int count = 0;
        while (off < b.length && count < len) {
            if (this.buffer.hasRemaining()) {
                b[off] = this.buffer.get();
                continue;
            }
            return -1;
        }
        return count;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("the stream is closed");
        }
        if (this.buffer == null) {
            this.doRead();
        }
        Preconditions.checkArgument(n >= 0L);
        n = Maths.minLong(this.buffer.remaining(), n);
        if (n > 0L) {
            this.buffer.position(this.buffer.position() + n);
        }
        return n;
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("the stream is closed");
        }
        if (this.buffer == null) {
            this.doRead();
        }
        return (int)this.buffer.remaining();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.buffer = null;
            super.close();
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.closed) {
            throw new IllegalStateException("the stream is closed");
        }
        if (this.buffer == null) {
            try {
                this.doRead();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.buffer.mark();
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("the stream is closed");
        }
        if (this.buffer == null) {
            this.doRead();
        }
        this.buffer.reset();
    }

    private void doRead() throws IOException {
        int bt;
        BigByteBuffer bf = this.bufferBuilder.build();
        while ((bt = this.in.read()) != -1) {
            bf.put((byte)bt);
        }
        this.buffer = bf;
        this.buffer.flip();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public Void rewind() {
        this.buffer.rewind();
        return null;
    }
}

