/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.stream;

import com.jn.langx.util.Maths;
import com.jn.langx.util.io.unicode.BOM;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class UnicodeInputStream
extends InputStream {
    private static final int BOM_MAX_SIZE = 4;
    protected volatile PushbackInputStream pushbackInputStream;
    private InputStream in;
    private BOM bom;

    public UnicodeInputStream(InputStream inputStream) throws IOException {
        this.pushbackInputStream = new PushbackInputStream(inputStream, 4);
        this.init();
    }

    public BOM getBom() {
        return this.bom;
    }

    private void init() throws IOException {
        int unread;
        BOM bom;
        if (this.in != null) {
            return;
        }
        byte[] bomBytes = new byte[4];
        int n = this.pushbackInputStream.read(bomBytes, 0, bomBytes.length);
        if (n < bomBytes.length) {
            byte[] bs = new byte[n];
            System.arraycopy(bomBytes, 0, bs, 0, n);
            bomBytes = bs;
        }
        if ((bom = BOM.findBom(bomBytes)) != null) {
            unread = n - bom.getBytes().length;
            this.bom = bom;
        } else {
            unread = n;
        }
        if (unread > 0) {
            this.pushbackInputStream.unread(bomBytes, n - unread, unread);
        }
        this.in = this.pushbackInputStream;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, Maths.min(len, 8192));
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }
}

