/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.stream;

import com.jn.langx.util.io.IOs;
import com.jn.langx.util.io.unicode.BOM;
import java.io.IOException;
import java.io.OutputStream;

public class UnicodeOutputStream
extends OutputStream {
    private OutputStream out;
    private BOM bom;

    public UnicodeOutputStream(OutputStream out, BOM bom) throws IOException {
        this.out = out;
        this.bom = bom;
        if (this.bom != null) {
            this.write(this.bom.getBytes());
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if ((off | len | b.length - (len + off) | off + len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.flush();
        }
        finally {
            IOs.close(this.out);
        }
    }
}

