/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.stream;

import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.io.unicode.BOM;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

public class UnicodeReader
extends Reader {
    PushbackInputStream pushbackInputStream;
    InputStreamReader internalReader = null;
    private static final int BOM_SIZE = 4;

    public UnicodeReader(InputStream in) {
        this.pushbackInputStream = new PushbackInputStream(in, 4);
    }

    public String getEncoding() {
        return this.internalReader.getEncoding();
    }

    protected void init() throws IOException {
        Charset encoding;
        int unread;
        BOM bom;
        if (this.internalReader != null) {
            return;
        }
        byte[] bomBytes = new byte[4];
        int n = this.pushbackInputStream.read(bomBytes, 0, bomBytes.length);
        if (n < bomBytes.length) {
            byte[] bs = new byte[n];
            System.arraycopy(bomBytes, 0, bs, 0, n);
            bomBytes = bs;
        }
        if ((bom = BOM.findBom(bomBytes)) != null) {
            unread = n - bom.getBytes().length;
            encoding = Charsets.getCharset(bom.getName());
        } else {
            unread = n;
            encoding = Charsets.UTF_8;
        }
        if (unread > 0) {
            this.pushbackInputStream.unread(bomBytes, n - unread, unread);
        }
        CharsetDecoder decoder = encoding.newDecoder().onUnmappableCharacter(CodingErrorAction.REPORT);
        this.internalReader = new InputStreamReader((InputStream)this.pushbackInputStream, decoder);
    }

    @Override
    public void close() throws IOException {
        this.init();
        this.internalReader.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.init();
        return this.internalReader.read(cbuf, off, len);
    }
}

