/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.stream.bandwidthlimit;

import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.retry.ThreadSleepWaitStrategy;
import com.jn.langx.util.retry.WaitStrategy;
import org.slf4j.Logger;

public class BandwidthLimiter {
    private static final Logger LOGGER = Loggers.getLogger(BandwidthLimiter.class);
    private static final Long CHUNK_LENGTH = 0x100000L;
    private int bytesWillBeSentOrReceive = 0;
    private long lastPieceSentOrReceiveTick = System.nanoTime();
    private int maxRate;
    private long timeCostPerChunk;
    private WaitStrategy waitStrategy;

    public BandwidthLimiter(int maxRate) {
        this(maxRate, new ThreadSleepWaitStrategy());
    }

    public BandwidthLimiter(int maxRate, WaitStrategy waitStrategy) {
        this.setMaxRate(maxRate);
        this.waitStrategy = waitStrategy;
    }

    public void setMaxRate(int maxRate) {
        if (maxRate < 0) {
            maxRate = 1024;
        }
        if (maxRate < 4) {
            maxRate = 4;
        }
        this.maxRate = maxRate;
        this.timeCostPerChunk = 1000000000L * CHUNK_LENGTH / ((long)this.maxRate * 1024L);
    }

    public synchronized void limitNextByte() {
        this.limitNextBytes(1);
    }

    public synchronized void limitNextBytes(int len) {
        this.bytesWillBeSentOrReceive += len;
        while ((long)this.bytesWillBeSentOrReceive > CHUNK_LENGTH) {
            long nowTick = System.nanoTime();
            long passTime = nowTick - this.lastPieceSentOrReceiveTick;
            long missedTime = this.timeCostPerChunk - passTime;
            if (missedTime > 0L) {
                try {
                    long waitTime = missedTime / 1000000L;
                    this.waitStrategy.await(waitTime);
                }
                catch (InterruptedException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            this.bytesWillBeSentOrReceive = (int)((long)this.bytesWillBeSentOrReceive - CHUNK_LENGTH);
            this.lastPieceSentOrReceiveTick = nowTick + (missedTime > 0L ? missedTime : 0L);
        }
    }
}

