/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.stream.obj;

import com.jn.langx.io.stream.obj.DefaultSecureObjectClassPredicate;
import com.jn.langx.io.stream.obj.SecureObjectClassPredicate;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Functions;
import com.jn.langx.util.function.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.List;

public class SecureObjectInputStream
extends ObjectInputStream {
    private Predicate<ObjectStreamClass> predicate;

    public SecureObjectInputStream(InputStream inputStream) throws IOException {
        this(inputStream, new SecureObjectClassPredicate[0]);
    }

    public SecureObjectInputStream(InputStream inputStream, SecureObjectClassPredicate ... predicates) throws IOException {
        super(inputStream);
        this.initPredicate(predicates);
    }

    private void initPredicate(SecureObjectClassPredicate ... predicates) {
        List ps = Pipeline.of(predicates).clearNulls().asList();
        this.predicate = ps.size() == 0 ? new DefaultSecureObjectClassPredicate() : Functions.allPredicate(ps);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        if (!this.isSafeClass(desc)) {
            throw new SecurityException(StringTemplates.formatWithPlaceholder("Illegal class name: {}", name));
        }
        return super.resolveClass(desc);
    }

    private boolean isSafeClass(ObjectStreamClass desc) {
        return this.predicate.test(desc);
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        return super.resolveProxyClass(interfaces);
    }
}

