/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.lifecycle;

import com.jn.langx.Named;
import com.jn.langx.lifecycle.AbstractInitializable;
import com.jn.langx.lifecycle.Initializable;
import com.jn.langx.lifecycle.Lifecycle;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.reflect.Reflects;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

public abstract class AbstractLifecycle
extends AbstractInitializable
implements Lifecycle,
Named,
Initializable {
    private Logger logger = Loggers.getLogger(this.getClass());
    private volatile boolean running;
    private String name;
    private final ReentrantLock lifecycleLock = new ReentrantLock();

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final boolean isRunning() {
        this.lifecycleLock.lock();
        try {
            boolean bl = this.running;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    @Override
    public final void startup() {
        this.lifecycleLock.lock();
        try {
            this.init();
            if (!this.running) {
                this.running = true;
                this.doStart();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("started {}", (Object)this);
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    @Override
    public final void shutdown() {
        this.lifecycleLock.lock();
        try {
            if (this.running) {
                this.doStop();
                this.running = false;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("stopped {}", (Object)this);
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final void stopAndExecute(Runnable callback) {
        this.lifecycleLock.lock();
        try {
            this.shutdown();
            callback.run();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    public String toString() {
        return StringTemplates.formatWithPlaceholder("{}:{}", Reflects.getFQNClassName(this.getClass()), this.getName());
    }
}

