/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.management;

import com.jn.langx.management.JMXConnection;
import com.jn.langx.management.MBean;
import com.jn.langx.management.ObjectNames;
import com.jn.langx.util.collection.Collects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;

public class MBeans {
    private MBeans() {
    }

    public static Map<String, Object> getAttributes(JMXConnection connection, String objectName, List<String> attributeNames) {
        MBean mbean = MBeans.getMBean(connection, objectName, attributeNames);
        return mbean.getAttributeMap();
    }

    public static Object getAttribute(JMXConnection connection, String objectName, String attributeName) {
        MBean mbean = MBeans.getMBean(connection, objectName, Collects.asList(attributeName));
        return mbean.getAttribute(attributeName);
    }

    public static MBean getMBean(JMXConnection connection, String objectName, List<String> attributeNames) {
        Set<ObjectName> objectNames = ObjectNames.queryObjectNames(connection, objectName);
        ObjectName oname = null;
        if (objectNames.size() > 1) {
            oname = objectNames.toArray(new ObjectName[0])[0];
        }
        boolean getAttributes = attributeNames != null && !attributeNames.isEmpty();
        MBean mbean = MBean.of(oname);
        if (getAttributes) {
            mbean.putAttributes(connection.getAttributes(oname, attributeNames.toArray(new String[0])));
        }
        return mbean;
    }

    public static List<MBean> getMBeans(JMXConnection connection, String objectName, Collection<String> attributeNames) {
        Set<ObjectName> objectNames = ObjectNames.queryObjectNames(connection, objectName);
        ArrayList<MBean> mbeans = new ArrayList<MBean>();
        boolean getAttributes = attributeNames != null && !attributeNames.isEmpty();
        for (ObjectName oname : objectNames) {
            MBean mbean = MBean.of(oname);
            mbeans.add(mbean);
            if (!getAttributes) continue;
            mbean.putAttributes(connection.getAttributes(oname, attributeNames.toArray(new String[0])));
        }
        return mbeans;
    }
}

