/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.management.connector.server.impl;

import com.jn.langx.management.connector.server.JMXConnectorServerWrapper;
import com.jn.langx.util.collection.Arrs;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.RMIClientSocketFactory;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;

public class RMIJMXConnectorServerWrapper
implements JMXConnectorServerWrapper {
    private static final String serverNameDefault = "jmxrmi";
    protected boolean startRmiRegistry = false;
    protected int rmiRegistryPort = -1;
    protected int rmiServerPort = -1;
    protected boolean rmiSSL = true;
    protected String[] ciphers = null;
    protected String[] protocols = null;
    protected boolean clientAuth = true;
    protected boolean authenticate = true;
    protected String passwordFile = null;
    protected String loginModuleName = null;
    protected String accessFile = null;
    protected boolean useLocalPorts = false;
    protected String host = "localhost";
    private String serviceName;
    protected JMXConnectorServer connectorServer = null;

    public RMIJMXConnectorServerWrapper() {
        this.init();
    }

    @Override
    public void shutdown() {
        this.destroyServer(this.connectorServer);
    }

    @Override
    public void startup() {
        System.setProperty("java.rmi.server.randomIDs", "true");
        HashMap<String, Object> env = new HashMap<String, Object>();
        RMIClientSocketFactory csf = null;
        SslRMIServerSocketFactory ssf = null;
        if (this.rmiSSL) {
            csf = new SslRMIClientSocketFactory();
            ssf = new SslRMIServerSocketFactory(this.ciphers, this.protocols, this.clientAuth);
        }
        if (this.useLocalPorts) {
            csf = new RmiClientLocalhostSocketFactory(csf);
        }
        if (csf != null) {
            env.put("jmx.remote.rmi.client.socket.factory", csf);
        }
        if (ssf != null) {
            env.put("jmx.remote.rmi.server.socket.factory", ssf);
        }
        if (this.authenticate) {
            env.put("jmx.remote.x.password.file", this.passwordFile);
            env.put("jmx.remote.x.access.file", this.accessFile);
            env.put("jmx.remote.x.login.config", this.loginModuleName);
        }
        this.connectorServer = this.createServer(env, ManagementFactory.getPlatformMBeanServer());
    }

    private void init() {
        String ciphersValue;
        String rmiSSLValue = System.getProperty("com.sun.management.jmxremote.ssl", "true");
        this.rmiSSL = Boolean.parseBoolean(rmiSSLValue);
        String protocolsValue = System.getProperty("com.sun.management.jmxremote.ssl.enabled.protocols");
        if (protocolsValue != null) {
            this.protocols = protocolsValue.split(",");
        }
        if ((ciphersValue = System.getProperty("com.sun.management.jmxremote.ssl.enabled.cipher.suites")) != null) {
            this.ciphers = ciphersValue.split(",");
        }
        String clientAuthValue = System.getProperty("com.sun.management.jmxremote.ssl.need.client.auth", "true");
        this.clientAuth = Boolean.parseBoolean(clientAuthValue);
        String authenticateValue = System.getProperty("com.sun.management.jmxremote.authenticate", "true");
        this.authenticate = Boolean.parseBoolean(authenticateValue);
        this.passwordFile = System.getProperty("com.sun.management.jmxremote.password.file", "jmxremote.password");
        this.accessFile = System.getProperty("com.sun.management.jmxremote.access.file", "jmxremote.access");
        this.loginModuleName = System.getProperty("com.sun.management.jmxremote.login.config");
        this.serviceName = serverNameDefault;
    }

    private JMXConnectorServer createServer(HashMap<String, Object> theEnv, MBeanServer theMBeanServer) {
        JMXServiceURL serviceUrl;
        if (this.rmiRegistryPort == -1 && !this.startRmiRegistry) {
            this.rmiRegistryPort = this.rmiServerPort;
        }
        try {
            LocateRegistry.createRegistry(this.rmiRegistryPort);
        }
        catch (RemoteException e) {
            return null;
        }
        StringBuilder url = new StringBuilder();
        if (this.startRmiRegistry) {
            url.append("service:jmx:rmi://").append(this.host).append(":");
            url.append(this.rmiServerPort);
            url.append("/jndi/rmi://").append(this.host).append(":");
            url.append(this.rmiRegistryPort);
            url.append("/").append(this.serviceName);
        } else {
            url.append("service:jmx:rmi:///jndi/rmi//").append(this.host).append(":").append(this.rmiServerPort).append("/").append(this.serviceName);
        }
        try {
            serviceUrl = new JMXServiceURL(url.toString());
        }
        catch (MalformedURLException e) {
            return null;
        }
        JMXConnectorServer cs = null;
        try {
            cs = JMXConnectorServerFactory.newJMXConnectorServer(serviceUrl, theEnv, theMBeanServer);
            cs.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cs;
    }

    private void destroyServer(JMXConnectorServer theConnectorServer) {
        if (theConnectorServer != null) {
            try {
                theConnectorServer.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getRmiRegistryPort() {
        return this.rmiRegistryPort;
    }

    public void setRmiRegistryPort(int rmiRegistryPort) {
        this.rmiRegistryPort = rmiRegistryPort;
    }

    public int getRmiServerPort() {
        return this.rmiServerPort;
    }

    public void setRmiServerPort(int rmiServerPort) {
        this.rmiServerPort = rmiServerPort;
    }

    public boolean isRmiSSL() {
        return this.rmiSSL;
    }

    public void setRmiSSL(boolean rmiSSL) {
        this.rmiSSL = rmiSSL;
    }

    public String[] getCiphers() {
        return Arrs.copy(this.ciphers);
    }

    public void setCiphers(String[] ciphers) {
        this.ciphers = ciphers;
    }

    public String[] getProtocols() {
        return Arrs.copy(this.protocols);
    }

    public void setProtocols(String[] protocols) {
        this.protocols = Arrs.copy(protocols);
    }

    public boolean isClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(boolean clientAuth) {
        this.clientAuth = clientAuth;
    }

    public boolean isAuthenticate() {
        return this.authenticate;
    }

    public void setAuthenticate(boolean authenticate) {
        this.authenticate = authenticate;
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }

    public String getLoginModuleName() {
        return this.loginModuleName;
    }

    public void setLoginModuleName(String loginModuleName) {
        this.loginModuleName = loginModuleName;
    }

    public String getAccessFile() {
        return this.accessFile;
    }

    public void setAccessFile(String accessFile) {
        this.accessFile = accessFile;
    }

    public boolean isUseLocalPorts() {
        return this.useLocalPorts;
    }

    public void setUseLocalPorts(boolean useLocalPorts) {
        this.useLocalPorts = useLocalPorts;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public final void setServiceName(String serviceName) {
        if (serviceName == null) {
            serviceName = serverNameDefault;
        } else {
            while (serviceName.startsWith("/")) {
                serviceName = serviceName.substring(1);
            }
        }
        if (serviceName.isEmpty()) {
            serviceName = serverNameDefault;
        }
        this.serviceName = serviceName;
    }

    public static class RmiClientLocalhostSocketFactory
    implements RMIClientSocketFactory {
        private static final String FORCED_HOST = "localhost";
        private RMIClientSocketFactory factory;

        public RmiClientLocalhostSocketFactory(RMIClientSocketFactory theFactory) {
            this.factory = theFactory;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            if (this.factory == null) {
                return new Socket(FORCED_HOST, port);
            }
            return this.factory.createSocket(FORCED_HOST, port);
        }
    }
}

