/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.management.service;

import com.jn.langx.management.BaseService;
import com.jn.langx.management.MBeanException;
import com.jn.langx.management.service.Unserializable;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Maps;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.struct.Entry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.slf4j.Logger;

public abstract class AbstractSpecifiedOptionService
extends BaseService {
    protected Map<String, Map<String, Object>> queryMBeanAttrs(String specifiedOption, Map<String, String> options, Collection<String> attributeNames) {
        Preconditions.checkNotNull(specifiedOption, "specialOption is null. ");
        ObjectName queryOname = this.createObjectName(options);
        Set<ObjectInstance> instances = this.conn.queryMBeans(queryOname, null);
        ArrayList<ObjectName> onames = new ArrayList<ObjectName>();
        if (instances != null && !instances.isEmpty()) {
            for (ObjectInstance ins : instances) {
                onames.add(ins.getObjectName());
            }
        }
        Logger logger = Loggers.getLogger(this.getClass());
        HashMap map = Maps.newLinkedHashMap();
        if (!onames.isEmpty()) {
            map = new HashMap();
            for (ObjectName oname : onames) {
                try {
                    List<Attribute> attrList = this.conn.getAttributes(oname, attributeNames.toArray(new String[0])).asList();
                    if (attrList == null || attrList.isEmpty()) continue;
                    HashMap<String, Object> mbean = new HashMap<String, Object>();
                    for (Attribute attr : attrList) {
                        String attrName = attr.getName();
                        Object attrValue = attr.getValue();
                        mbean.put(attrName, attrValue);
                    }
                    map.put((String)oname.getKeyProperty(specifiedOption), mbean);
                }
                catch (Exception ex) {
                    logger.error("Get thread pool infoes error", (Throwable)ex);
                }
            }
        }
        return map;
    }

    protected Map<String, List<Entry<String, Object>>> getMBeansAttrs(String specifiedOption, List<String> optionValues, Collection<String> attributeNames) throws Exception {
        Preconditions.checkNotNull(specifiedOption, "specialOption is null. ");
        HashMap<String, List<Entry<String, Object>>> result = new HashMap<String, List<Entry<String, Object>>>();
        if (attributeNames.isEmpty()) {
            return result;
        }
        LinkedList<ObjectName> objectNames = new LinkedList<ObjectName>();
        if (optionValues == null || optionValues.isEmpty()) {
            ObjectName oname = this.createObjectName(null);
            Set<ObjectName> allValue = this.conn.queryNames(oname, null);
            objectNames.addAll(allValue);
        } else {
            for (String optionValue : optionValues) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put(specifiedOption, optionValue);
                ObjectName oname2 = this.createObjectName(options);
                objectNames.add(oname2);
            }
        }
        try {
            Logger logger = Loggers.getLogger(this.getClass());
            for (ObjectName oname3 : objectNames) {
                List<Attribute> attrList;
                if (logger.isDebugEnabled()) {
                    logger.debug("query attributes : {}", attributeNames);
                }
                if ((attrList = this.conn.getAttributes(oname3, attributeNames.toArray(new String[0])).asList()) == null) continue;
                LinkedList<Entry<String, Object>> mbean = new LinkedList<Entry<String, Object>>();
                String optionName = oname3.getKeyProperty(specifiedOption);
                for (Attribute attr : attrList) {
                    String attrName = attr.getName();
                    Object attrValue = attr.getValue();
                    mbean.add(new Entry<String, Object>(attrName, attrValue));
                }
                result.put(optionName, mbean);
            }
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
        return result;
    }

    protected Map<String, List<Entry<String, Object>>> getMBeans(String specifiedOption, List<String> optionValues) throws Exception {
        return this.getMBeans(specifiedOption, optionValues, null);
    }

    protected Map<String, List<Entry<String, Object>>> getMBeans(String specifiedOption, List<String> optionValues, Class<? extends Unserializable> unserialClazz) throws MBeanException {
        if (!Strings.isBlank(specifiedOption)) {
            throw new MBeanException("specialOption is null. ");
        }
        LinkedList<ObjectName> objectNames = new LinkedList<ObjectName>();
        if (optionValues == null || optionValues.isEmpty()) {
            ObjectName oname = this.createObjectName(null);
            Set<ObjectName> allValue = this.conn.queryNames(oname, null);
            objectNames.addAll(allValue);
        } else {
            for (String optionValue : optionValues) {
                Hashtable<String, String> options = new Hashtable<String, String>();
                options.put(specifiedOption, optionValue);
                ObjectName oname2 = this.createObjectName(options);
                objectNames.add(oname2);
            }
        }
        ArrayList<String> notSerialAttrs = new ArrayList<String>();
        if (unserialClazz != null && Reflects.isSubClassOrEquals(Unserializable.class, unserialClazz)) {
            Collection<Field> fields = Reflects.getAllDeclaredFields(unserialClazz, true);
            for (Field field : fields) {
                notSerialAttrs.add(field.getName());
            }
        }
        HashMap<String, List<Entry<String, Object>>> result = new HashMap<String, List<Entry<String, Object>>>();
        try {
            Logger logger = Loggers.getLogger(this.getClass());
            for (ObjectName oname2 : objectNames) {
                List<Attribute> attrList;
                MBeanInfo mbeanInfo = this.conn.getMBeanInfo(oname2);
                MBeanAttributeInfo[] attrInfos = mbeanInfo.getAttributes();
                LinkedList<String> attributeNames = new LinkedList<String>();
                for (MBeanAttributeInfo attrInfo : attrInfos) {
                    String attrName = attrInfo.getName();
                    if (notSerialAttrs.contains(attrName)) continue;
                    attributeNames.add(attrName);
                }
                if (attributeNames.isEmpty()) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("query attributes : {}", attributeNames);
                }
                if ((attrList = this.conn.getAttributes(oname2, attributeNames.toArray(new String[0])).asList()) == null) continue;
                LinkedList<Entry<String, Object>> mbean = new LinkedList<Entry<String, Object>>();
                String optionName = oname2.getKeyProperty(specifiedOption);
                for (Attribute attr : attrList) {
                    String attrName2 = attr.getName();
                    Object attrValue = attr.getValue();
                    mbean.add(new Entry<String, Object>(attrName2, attrValue));
                }
                result.put(optionName, mbean);
            }
        }
        catch (Exception ex) {
            throw new MBeanException(ex);
        }
        return result;
    }
}

