/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.pipeline;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.pipeline.Handler;
import com.jn.langx.pipeline.Pipeline;
import com.jn.langx.pipeline.Pipelines;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.struct.Holder;

public class HandlerContext {
    @Nullable
    private HandlerContext prev;
    @Nullable
    private HandlerContext next;
    @NonNull
    private Handler handler;
    @NonNull
    private Pipeline pipeline;
    private boolean inbounded = false;
    private boolean outbounded = false;
    private boolean skiped = false;

    public HandlerContext(Handler handler) {
        Preconditions.checkNotNull(handler);
        this.handler = handler;
    }

    public void setNext(HandlerContext next) {
        this.next = next;
    }

    public void setPrev(HandlerContext prev) {
        this.prev = prev;
    }

    public void inbound() throws Throwable {
        if (this.isSkiped()) {
            Pipelines.skipHandler(this, true);
        }
        this.getPipeline().setCurrentHandlerContext(this);
        this.inbounded = true;
        this.handler.inbound(this);
    }

    public void outbound() throws Throwable {
        if (this.isSkiped()) {
            Pipelines.skipHandler(this, false);
        }
        this.getPipeline().setCurrentHandlerContext(this);
        this.outbounded = true;
        this.handler.outbound(this);
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public HandlerContext getNext() {
        return this.next;
    }

    public boolean hasPrev() {
        return this.prev != null;
    }

    public HandlerContext getPrev() {
        return this.prev;
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean removeHandler) {
        this.next = null;
        this.prev = null;
        this.skiped = false;
        this.outbounded = false;
        this.inbounded = false;
        if (removeHandler) {
            this.handler = null;
        }
    }

    Handler getHandler() {
        return this.handler;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    public boolean isInbounded() {
        return this.inbounded;
    }

    public void setInbounded(boolean inbounded) {
        this.inbounded = inbounded;
    }

    public boolean isOutbounded() {
        return this.outbounded;
    }

    public void setOutbounded(boolean outbounded) {
        this.outbounded = outbounded;
    }

    public boolean isSkiped() {
        return this.skiped;
    }

    public void setSkiped(boolean skiped) {
        this.skiped = skiped;
    }

    public String toString() {
        return "HandlerContext{handler=" + this.handler + ", pipeline=" + this.pipeline + '}';
    }

    public Object getTarget() {
        return this.pipeline.getTarget();
    }

    public Holder getCurrentValueHolder() {
        return this.pipeline.getTargetHolder();
    }
}

