/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.propertyset;

import com.jn.langx.propertyset.AbstractPropertySet;
import com.jn.langx.propertyset.PropertySet;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Listable;
import com.jn.langx.util.function.Predicate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MultiplePropertySet
extends AbstractPropertySet
implements Listable<PropertySet> {
    private final List<PropertySet> propertySets = new CopyOnWriteArrayList<PropertySet>();

    public MultiplePropertySet() {
        this("multiple-property-sets");
    }

    public MultiplePropertySet(String name) {
        this(name, null);
    }

    public MultiplePropertySet(String name, List<PropertySet> propertySets) {
        super(name, new Object());
        Collects.addTo(propertySets, this.propertySets);
    }

    @Override
    public Object getProperty(String key) {
        return this.getProperty(key, null);
    }

    public Object getProperty(String key, String valueIfAbsent) {
        for (PropertySet set : this.propertySets) {
            if (!set.containsProperty(key)) continue;
            return set.getProperty(key);
        }
        return valueIfAbsent;
    }

    @Override
    public boolean containsProperty(final String name) {
        return Collects.anyMatch(this.propertySets, new Predicate<PropertySet>(){

            @Override
            public boolean test(PropertySet set) {
                return set.containsProperty(name);
            }
        });
    }

    public boolean addFirst(PropertySet propertySet) {
        this.propertySets.add(0, propertySet);
        return true;
    }

    @Override
    public boolean add(PropertySet propertySet) {
        this.propertySets.add(propertySet);
        return true;
    }

    @Override
    public boolean remove(Object e) {
        return this.propertySets.remove(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBefore(String refPropertySetName, PropertySet propertySet) {
        List<PropertySet> list = this.propertySets;
        synchronized (list) {
            this.remove(propertySet);
            int index = this.findRelativePropertySetIndex(refPropertySetName, propertySet);
            this.propertySets.add(index, propertySet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAfter(String refPropertySetName, PropertySet propertySet) {
        List<PropertySet> list = this.propertySets;
        synchronized (list) {
            this.remove(propertySet);
            int index = this.findRelativePropertySetIndex(refPropertySetName, propertySet);
            this.propertySets.add(index + 1, propertySet);
        }
    }

    private int findRelativePropertySetIndex(String refPropertySetName, PropertySet propertySet) {
        Preconditions.checkNotEmpty(refPropertySetName, "the property set name is empty");
        if (Strings.equals(propertySet.getName(), refPropertySetName)) {
            throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder("duplicated property set name: {}", refPropertySetName));
        }
        int index = Collects.firstOccurrence(this.propertySets, propertySet);
        if (index < 0) {
            throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder("non exists property set: {}", refPropertySetName));
        }
        return index;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.propertySets.removeAll(collection);
    }

    @Override
    public void clear() {
        this.propertySets.clear();
    }

    @Override
    public boolean addAll(Collection<? extends PropertySet> elements) {
        this.propertySets.addAll(elements);
        return true;
    }

    @Override
    public Iterator<PropertySet> iterator() {
        return this.propertySets.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.propertySets.isEmpty();
    }

    @Override
    public boolean isNull() {
        return this.isEmpty();
    }
}

