/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security;

import com.jn.langx.security.crypto.JCAEStandardName;
import com.jn.langx.security.crypto.key.PKIs;
import com.jn.langx.security.crypto.provider.LangxSecurityProvider;
import com.jn.langx.security.gm.GmInitializer;
import com.jn.langx.util.Strings;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.spi.CommonServiceProvider;
import com.jn.langx.util.struct.Holder;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Map;

public class Securitys {
    private static volatile boolean providersLoaded = false;
    private static LangxSecurityProvider langxSecurityProvider;
    private static final SecureRandom SECURE_RANDOM;

    protected Securitys() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setup() {
        Securitys.unlimitJCECryptoPolicy();
        if (providersLoaded) return;
        Class<Securitys> clazz = Securitys.class;
        synchronized (Securitys.class) {
            Securitys.loadProviders();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void unlimitJCECryptoPolicy() {
        try {
            Class<?> clazz = Class.forName("javax.crypto.JceSecurity");
            Field isRestrictedField = clazz.getDeclaredField("isRestricted");
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            Reflects.setFieldValue(modifiersField, isRestrictedField, isRestrictedField.getModifiers() & 0xFFFFFFEF, true, true);
            Reflects.setFieldValue(isRestrictedField, null, Boolean.FALSE, true, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Provider getProvider(String name) {
        if (Strings.isBlank(name)) {
            return null;
        }
        return Security.getProvider(name);
    }

    public static void addProvider(Provider provider) {
        Security.addProvider(provider);
    }

    public static void insertProvider(Provider provider) {
        Securitys.insertProviderAt(provider, 1);
    }

    public static void insertProviderAt(Provider provider, int position) {
        Security.insertProviderAt(provider, position);
    }

    public static void loadLangxProvider() {
        LangxSecurityProvider langxSecurityProvider = new LangxSecurityProvider();
        Provider[] providers = Security.getProviders();
        ClassLoader appClassLoader = ClassLoader.getSystemClassLoader();
        if (appClassLoader.getParent() instanceof URLClassLoader) {
            final URLClassLoader extClassLoader = (URLClassLoader)appClassLoader.getParent();
            final Holder firstProviderInExtClassLoader = new Holder();
            Provider expectedProvider = Collects.findFirst(Collects.asList(providers), new Predicate<Provider>(){

                @Override
                public boolean test(Provider provider) {
                    ClassLoader providerCL = provider.getClass().getClassLoader();
                    if (providerCL != null && providerCL != extClassLoader) {
                        return true;
                    }
                    if (providerCL == extClassLoader && firstProviderInExtClassLoader.isNull()) {
                        firstProviderInExtClassLoader.set(provider);
                    }
                    return false;
                }
            });
            if (expectedProvider != null) {
                Map<String, String> properties = langxSecurityProvider.getProperties();
                expectedProvider.putAll(properties);
            }
        }
        Securitys.insertProvider(langxSecurityProvider);
        Securitys.langxSecurityProvider = langxSecurityProvider;
    }

    public static boolean langxProviderInstalled() {
        return Security.getProvider("langx-java-security-provider") != null;
    }

    public static LangxSecurityProvider getLangxSecurityProvider() {
        return langxSecurityProvider;
    }

    private static void loadGMSupports() {
        for (GmInitializer initializer : CommonServiceProvider.loadService(GmInitializer.class)) {
            initializer.init();
        }
    }

    private static void loadProviders() {
        Securitys.loadGMSupports();
        Securitys.loadLangxProvider();
    }

    public static SecureRandom getSecureRandom() {
        return SECURE_RANDOM;
    }

    public static int getBytesLength(int bitLength) {
        if (bitLength < 0) {
            return -1;
        }
        return (bitLength + 7) / 8;
    }

    public static byte[] randomBytes(int bitLength) {
        return Securitys.randomBytes(null, bitLength);
    }

    public static byte[] randomBytes(SecureRandom secureRandom, int bitLength) {
        if (secureRandom == null) {
            try {
                secureRandom = SecureRandom.getInstance(JCAEStandardName.SHA1PRNG.getName());
            }
            catch (Throwable ex) {
                throw Throwables.wrapAsRuntimeException(ex);
            }
        }
        int byteLength = PKIs.getBytesLength(bitLength);
        byte[] bytes = new byte[byteLength];
        secureRandom.nextBytes(bytes);
        return bytes;
    }

    static {
        Securitys.setup();
        SECURE_RANDOM = new SecureRandom();
    }
}

