/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.security.crypto.Algorithm;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Arrs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.reflect.Reflects;
import java.util.EnumSet;
import java.util.List;

public enum JCAEStandardName {
    NativePRNG,
    NativePRNGBlocking,
    NativePRNGNonBlocking,
    PKCS11PRNG,
    DRBG,
    SHA1PRNG,
    Windows_PRNG,
    SHA_1,
    SHA_224,
    SHA_256,
    SHA_384,
    SHA3,
    SHA3_224,
    SHA3_256,
    SHA3_384,
    SHA3_512,
    SHA_512,
    MD2,
    MD4,
    MD5,
    SM3,
    DSA,
    RSA,
    SM2,
    AES,
    DES,
    DESede,
    SM4,
    NONE_RSA,
    MD2_RSA,
    MD5_RSA,
    SHA1_RSA,
    SHA224_RSA,
    SHA256_RSA,
    SHA384_RSA,
    SHA512_RSA,
    SHA512_224_RSA,
    SHA512_256_RSA,
    SHA3_224_RSA,
    SHA3_256_RSA,
    SHA3_384_RSA,
    SHA3_512_RSA,
    SHA1_DSA,
    ECDSA,
    X509("X.509"),
    JCEKS,
    JKS,
    DKS,
    PKCS11,
    PKCS12;

    private String name;
    private boolean isAlgorithm = false;
    private Class[] scenarios;

    private JCAEStandardName() {
        Algorithm algorithm = Reflects.getDeclaredField(JCAEStandardName.class, this.name()).getAnnotation(Algorithm.class);
        if (algorithm != null) {
            this.name = algorithm.name();
            this.isAlgorithm = true;
            this.scenarios = algorithm.apply();
        } else {
            this.name = this.name();
        }
    }

    private JCAEStandardName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean isAlgorithm() {
        return this.isAlgorithm;
    }

    public Class[] getScenarios() {
        return Arrs.copy(this.scenarios);
    }

    public static List<JCAEStandardName> findAlgorithms(final @NonNull Class scenario) {
        Preconditions.checkNotNull(scenario);
        return Pipeline.of(EnumSet.allOf(JCAEStandardName.class)).filter(new Predicate<JCAEStandardName>(){

            @Override
            public boolean test(JCAEStandardName sn) {
                return sn.isAlgorithm() && Collects.contains(sn.scenarios, scenario);
            }
        }).asList();
    }
}

