/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.cipher;

import com.jn.langx.Named;
import com.jn.langx.annotation.NotEmpty;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.security.crypto.cipher.AlgorithmParameterSupplier;
import com.jn.langx.util.Preconditions;

public class CipherAlgorithmSuite
implements Named {
    @NotEmpty
    private String algorithm;
    @NotEmpty
    private String transformation;
    @Nullable
    private Integer keySize;
    @Nullable
    private AlgorithmParameterSupplier parameterSupplier;

    public CipherAlgorithmSuite() {
    }

    public CipherAlgorithmSuite(String algorithm, String transformation) {
        this(algorithm, transformation, null);
    }

    public CipherAlgorithmSuite(String algorithm, String transformation, AlgorithmParameterSupplier parameterSupplier) {
        this(algorithm, transformation, parameterSupplier, null);
    }

    public CipherAlgorithmSuite(String algorithm, String transformation, AlgorithmParameterSupplier parameterSupplier, Integer keySize) {
        this.setName(algorithm);
        this.setTransformation(transformation);
        this.setParameterSupplier(parameterSupplier);
        this.setKeySize(keySize);
    }

    public void setKeySize(Integer keySize) {
        this.keySize = keySize;
    }

    public Integer getKeySize() {
        return this.keySize;
    }

    @Override
    public String getName() {
        return this.algorithm;
    }

    public void setName(String algorithm) {
        Preconditions.checkNotEmpty(algorithm);
        this.algorithm = algorithm;
    }

    public String getTransformation() {
        return this.transformation;
    }

    public void setTransformation(String transformation) {
        Preconditions.checkNotEmpty(transformation);
        this.transformation = transformation;
    }

    public AlgorithmParameterSupplier getParameterSupplier() {
        return this.parameterSupplier;
    }

    public void setParameterSupplier(AlgorithmParameterSupplier parameterSupplier) {
        this.parameterSupplier = parameterSupplier;
    }
}

