/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.cipher;

import com.jn.langx.annotation.NotEmpty;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.registry.GenericRegistry;
import com.jn.langx.security.crypto.cipher.AlgorithmParameterSupplier;
import com.jn.langx.security.crypto.cipher.CipherAlgorithmSuite;
import com.jn.langx.security.crypto.cipher.CipherAlgorithmSuiteSupplier;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.comparator.OrderedComparator;
import com.jn.langx.util.comparator.ReverseComparator;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.spi.CommonServiceProvider;
import java.util.Iterator;
import java.util.List;

public class CipherAlgorithmSuiteRegistry
extends GenericRegistry<CipherAlgorithmSuite> {
    @Override
    protected void doInit() throws InitializationException {
        CommonServiceProvider serviceProvider = new CommonServiceProvider();
        serviceProvider.setComparator(new ReverseComparator(new OrderedComparator()));
        Iterator<CipherAlgorithmSuiteSupplier> iterator = serviceProvider.get(CipherAlgorithmSuiteSupplier.class);
        Pipeline.of(iterator).map(new Function<CipherAlgorithmSuiteSupplier, List<CipherAlgorithmSuite>>(){

            @Override
            public List<CipherAlgorithmSuite> apply(CipherAlgorithmSuiteSupplier supplier) {
                return supplier.get();
            }
        }).flat().forEach(new Consumer<CipherAlgorithmSuite>(){

            @Override
            public void accept(CipherAlgorithmSuite suite) {
                CipherAlgorithmSuiteRegistry.this.register(suite);
            }
        });
    }

    public void add(String algorithm, String transformation) {
        this.add(algorithm, transformation, null);
    }

    public void add(@NotEmpty String algorithm, @NotEmpty String transformation, @Nullable AlgorithmParameterSupplier supplier) {
        CipherAlgorithmSuite suite = new CipherAlgorithmSuite(algorithm, transformation, supplier);
        this.register(suite);
    }

    public String getTransformation(String algorithm) {
        CipherAlgorithmSuite suite = (CipherAlgorithmSuite)this.get(algorithm);
        return suite == null ? null : suite.getTransformation();
    }

    public AlgorithmParameterSupplier getParmameterSupplier(String algorithm) {
        CipherAlgorithmSuite suite = (CipherAlgorithmSuite)this.get(algorithm);
        return suite == null ? null : suite.getParameterSupplier();
    }
}

