/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.digest;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.codec.hex.Hex;
import com.jn.langx.security.crypto.digest.MessageDigests;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.io.file.Files;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.struct.Holder;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.List;

public class FileDigestGenerator {
    private boolean lowercase = true;

    public String generate(String filePath, String algorithm) {
        return this.generate(filePath, (FileReader)null, algorithm);
    }

    public String generate(String filePath, FileReader reader, String algorithm) {
        return this.generate(filePath, reader, new String[]{algorithm}).get(0);
    }

    public List<String> generate(String filePath, FileReader reader, String ... algorithms) {
        try {
            List<String> digests = FileDigestGenerator.getFileDigestStrings(filePath, reader, algorithms);
            if (!this.lowercase) {
                return Pipeline.of(digests).map(new Function<String, String>(){

                    @Override
                    public String apply(String input) {
                        return input.toUpperCase();
                    }
                }).asList();
            }
            return digests;
        }
        catch (FileNotFoundException ex) {
            throw Throwables.wrapAsRuntimeException(ex);
        }
    }

    public boolean isLowercase() {
        return this.lowercase;
    }

    public void setLowercase(boolean lowercase) {
        this.lowercase = lowercase;
    }

    public static String getFileDigest(String filePath, String algorithm, @Nullable FileReader reader) throws FileNotFoundException {
        List<byte[]> hashBytesList = FileDigestGenerator.getFileDigest(filePath, reader, algorithm);
        if (Emptys.isEmpty(hashBytesList)) {
            throw new IllegalArgumentException();
        }
        return Hex.encodeHexString(hashBytesList.get(0));
    }

    public static List<String> getFileDigestStrings(String filePath, @Nullable FileReader reader, String ... algorithms) throws FileNotFoundException {
        return Pipeline.of(FileDigestGenerator.getFileDigest(filePath, reader, Pipeline.of(algorithms).map(new Function<String, MessageDigest>(){

            @Override
            public MessageDigest apply(String algorithm) {
                return MessageDigests.newDigest(algorithm);
            }
        }).asList())).map(new Function<byte[], String>(){

            @Override
            public String apply(byte[] bytes) {
                return Hex.encodeHexString(bytes);
            }
        }).asList();
    }

    public static List<byte[]> getFileDigest(String filePath, @Nullable FileReader reader, String ... algorithms) throws FileNotFoundException {
        return FileDigestGenerator.getFileDigest(filePath, reader, Pipeline.of(algorithms).map(new Function<String, MessageDigest>(){

            @Override
            public MessageDigest apply(String algorithm) {
                return MessageDigests.newDigest(algorithm);
            }
        }).asList());
    }

    public static List<String> getFileDigestStrings(String filePath, @Nullable FileReader reader, MessageDigest ... messageDigests) throws FileNotFoundException {
        return Pipeline.of(FileDigestGenerator.getFileDigest(filePath, reader, Collects.asList(messageDigests))).map(new Function<byte[], String>(){

            @Override
            public String apply(byte[] bytes) {
                return Hex.encodeHexString(bytes);
            }
        }).asList();
    }

    public static List<byte[]> getFileDigest(String filePath, @Nullable FileReader reader, MessageDigest ... messageDigests) throws FileNotFoundException {
        return FileDigestGenerator.getFileDigest(filePath, reader, Collects.asList(messageDigests));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<byte[]> getFileDigest(String filePath, @Nullable FileReader reader, List<MessageDigest> messageDigests) throws FileNotFoundException {
        if (Emptys.isEmpty(messageDigests)) {
            return Collects.newArrayList();
        }
        File file = new File(filePath);
        if (!file.exists() || !file.canRead()) {
            throw new FileNotFoundException(" can't find file [" + filePath + "] or it is not readable");
        }
        reader = reader == null ? FileReaderFactory.getFileReader(filePath) : reader;
        try {
            reader.setFile(file);
            while (reader.hasNext()) {
                final Holder<byte[]> bytes = new Holder<byte[]>(reader.next());
                if (bytes.isEmpty()) continue;
                Collects.forEach(messageDigests, new Consumer2<Integer, MessageDigest>(){

                    @Override
                    public void accept(Integer index, MessageDigest messageDigest) {
                        messageDigest.update((byte[])bytes.get());
                    }
                });
            }
            List<byte[]> list = Pipeline.of(messageDigests).map(new Function<MessageDigest, byte[]>(){

                @Override
                public byte[] apply(MessageDigest messageDigest) {
                    return messageDigest.digest();
                }
            }).asList();
            return list;
        }
        finally {
            IOs.close(reader);
        }
    }

    public static String getFileDigest(String filePath, String algorithm) throws FileNotFoundException {
        return FileDigestGenerator.getFileDigest(filePath, algorithm, null);
    }

    static class FileReaderFactory {
        private static final long SIZE_10M = 0xA00000L;

        private FileReaderFactory() {
        }

        public static FileReader getFileReader(String filePath) {
            File file = new File(filePath);
            if (file.length() > 0xA00000L) {
                return new MMapedFileReader();
            }
            return new BufferedFileReader();
        }
    }

    public static class MMapedFileReader
    extends FileReader<FileChannel> {
        private MappedByteBuffer currentMMapBuffer;
        private long nextMapStartPosition = 0L;
        private long remainingLength = 0L;

        @Override
        public void setFile(File file) {
            super.setFile(file);
            FileInputStream fileInput = Files.openInputStream(file);
            if (fileInput != null) {
                this.input = fileInput.getChannel();
            }
            this.remainingLength = this.fileLength;
        }

        @Override
        public byte[] next() {
            if (this.currentMMapBuffer == null || this.currentMMapBuffer.remaining() <= 0) {
                this.mapNextFilePart();
            }
            if (this.currentMMapBuffer.remaining() > 0) {
                int maxLength = 0x100000;
                byte[] bytes = new byte[Math.min(this.currentMMapBuffer.remaining(), maxLength)];
                this.currentMMapBuffer.get(bytes);
                this.remainingLength -= (long)bytes.length;
                this.readedLength += (long)bytes.length;
                return bytes;
            }
            return new byte[0];
        }

        private int mapNextFilePart() {
            int mmapsize = this.remainingLength >= Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.parseInt(this.remainingLength + "");
            try {
                this.currentMMapBuffer = ((FileChannel)this.input).map(FileChannel.MapMode.READ_ONLY, this.nextMapStartPosition, mmapsize);
            }
            catch (IOException e) {
                Loggers.getLogger(FileDigestGenerator.class).error(e.getMessage(), (Throwable)e);
            }
            this.nextMapStartPosition += (long)mmapsize;
            return mmapsize;
        }
    }

    public static class BufferedFileReader
    extends FileReader<BufferedInputStream> {
        @Override
        public void setFile(File file) {
            FileInputStream fileInput = Files.openInputStream(file);
            if (fileInput != null) {
                this.input = new BufferedInputStream(fileInput);
            }
            super.setFile(file);
        }

        @Override
        public byte[] next() {
            int maxLength = 1024;
            byte[] bytes = new byte[maxLength];
            int length = -1;
            try {
                length = ((BufferedInputStream)this.input).read(bytes);
            }
            catch (IOException e) {
                Loggers.getLogger(FileDigestGenerator.class).error("error when read file: {}", (Object)e.getMessage());
            }
            if (length != -1) {
                byte[] ret = length == maxLength ? bytes : new byte[length];
                if (length > 0 && length < maxLength) {
                    System.arraycopy(bytes, 0, ret, 0, length);
                }
                return ret;
            }
            this.readedLength = this.fileLength;
            return new byte[0];
        }
    }

    public static abstract class FileReader<INPUT extends Closeable>
    implements Iterator<byte[]>,
    Closeable {
        protected INPUT input;
        protected long fileLength;
        protected long readedLength = 0L;

        public void setFile(File file) {
            this.fileLength = file.length();
        }

        @Override
        public final boolean hasNext() {
            boolean hasNext;
            boolean bl = hasNext = this.input != null && this.readedLength < this.fileLength;
            if (!hasNext) {
                this.close();
            }
            return hasNext;
        }

        @Override
        public final void close() {
            IOs.close(this.input);
        }

        @Override
        public abstract byte[] next();

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

