/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.digest;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.codec.StringifyFormat;
import com.jn.langx.codec.Stringifys;
import com.jn.langx.security.crypto.AlgorithmUnregisteredException;
import com.jn.langx.security.crypto.digest.MessageDigests;
import com.jn.langx.security.crypto.salt.BytesSaltGenerator;
import com.jn.langx.security.crypto.salt.EmptySaltGenerator;
import com.jn.langx.security.crypto.salt.FixedBytesSaltGenerator;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Maths;
import java.security.MessageDigest;

public class MessageDigestHasher {
    private static final int DEFAULT_ITERATIONS = 1;
    private int saltBytesLength = 0;
    @NonNull
    private BytesSaltGenerator saltGenerator = new EmptySaltGenerator();
    private int iterations = 1;
    @NonNull
    private String algorithmName;

    public void setSalt(byte[] salt) {
        if (salt != null) {
            this.setSaltGenerator(new FixedBytesSaltGenerator(salt));
            this.setSaltBytesLength(salt.length);
        }
    }

    public void setSaltBytesLength(int saltBytesLength) {
        this.saltBytesLength = saltBytesLength;
    }

    public void setSaltGenerator(BytesSaltGenerator saltGenerator) {
        this.saltGenerator = saltGenerator;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = Maths.max(1, iterations);
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        if (Emptys.isNotEmpty(algorithmName)) {
            this.algorithmName = algorithmName;
        }
    }

    public MessageDigestHasher(@NonNull String algorithmName) {
        this(algorithmName, null);
    }

    public MessageDigestHasher(@NonNull String algorithmName, byte[] salt) {
        this(algorithmName, salt, 1);
    }

    public MessageDigestHasher(@NonNull String algorithmName, @Nullable byte[] salt, int hashIterations) {
        this.setAlgorithmName(algorithmName);
        this.setIterations(hashIterations);
        this.setSalt(salt);
    }

    public byte[] hash(byte[] source) {
        byte[] salt = this.saltGenerator.get(this.saltBytesLength);
        return this.doHash(source, salt, this.iterations);
    }

    public String hash(byte[] source, StringifyFormat outputFormat) {
        byte[] hashed = this.hash(source);
        return Stringifys.stringify(hashed, outputFormat);
    }

    protected final byte[] doHash(byte[] data, byte[] salt, int iterations) {
        MessageDigest digest = MessageDigests.newDigest(this.algorithmName);
        if (digest == null) {
            throw new AlgorithmUnregisteredException(this.algorithmName);
        }
        byte[] bytes = data;
        if (Emptys.isNotEmpty(salt)) {
            digest.reset();
            bytes = digest.digest(salt);
        }
        iterations = Maths.max(1, iterations);
        for (int i = 0; i < iterations; ++i) {
            digest.reset();
            bytes = digest.digest(bytes);
        }
        return bytes;
    }
}

