/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.digest.internal.impl;

import com.jn.langx.security.crypto.digest.internal.impl._AbstractLongDigest;
import com.jn.langx.util.Memoable;
import com.jn.langx.util.io.bytes.Bytes;

public final class _SHA384Digest
extends _AbstractLongDigest {
    private static final int DIGEST_LENGTH = 48;

    public _SHA384Digest() {
    }

    public _SHA384Digest(_SHA384Digest t) {
        super(t);
    }

    public _SHA384Digest(byte[] encodedState) {
        this.restoreState(encodedState);
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-384";
    }

    @Override
    public int getDigestSize() {
        return 48;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.finish();
        Bytes.longToBigEndian(this.H1, out, outOff);
        Bytes.longToBigEndian(this.H2, out, outOff + 8);
        Bytes.longToBigEndian(this.H3, out, outOff + 16);
        Bytes.longToBigEndian(this.H4, out, outOff + 24);
        Bytes.longToBigEndian(this.H5, out, outOff + 32);
        Bytes.longToBigEndian(this.H6, out, outOff + 40);
        this.reset();
        return 48;
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = -3766243637369397544L;
        this.H2 = 7105036623409894663L;
        this.H3 = -7973340178411365097L;
        this.H4 = 1526699215303891257L;
        this.H5 = 7436329637833083697L;
        this.H6 = -8163818279084223215L;
        this.H7 = -2662702644619276377L;
        this.H8 = 5167115440072839076L;
    }

    @Override
    public Memoable copy() {
        return new _SHA384Digest(this);
    }

    @Override
    public void reset(Memoable other) {
        _SHA384Digest d = (_SHA384Digest)other;
        super.copyIn(d);
    }

    public byte[] getEncodedState() {
        byte[] encoded = new byte[this.getEncodedStateSize()];
        super.populateState(encoded);
        return encoded;
    }
}

