/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.digest.internal.impl;

import com.jn.langx.security.crypto.digest.internal.impl._KeccakDigest;

public final class _SHA3Digest
extends _KeccakDigest {
    private static int checkBitLength(int bitLength) {
        switch (bitLength) {
            case 224: 
            case 256: 
            case 384: 
            case 512: {
                return bitLength;
            }
        }
        throw new IllegalArgumentException("'bitLength' " + bitLength + " not supported for SHA-3");
    }

    public _SHA3Digest() {
        this(256);
    }

    public _SHA3Digest(int bitLength) {
        super(_SHA3Digest.checkBitLength(bitLength));
    }

    public _SHA3Digest(_SHA3Digest source) {
        super(source);
    }

    @Override
    public String getAlgorithmName() {
        return "SHA3-" + this.fixedOutputLength;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.absorbBits(2, 2);
        return super.doFinal(out, outOff);
    }

    @Override
    protected int doFinal(byte[] out, int outOff, byte partialByte, int partialBits) {
        if (partialBits < 0 || partialBits > 7) {
            throw new IllegalArgumentException("'partialBits' must be in the range [0,7]");
        }
        int finalInput = partialByte & (1 << partialBits) - 1 | 2 << partialBits;
        int finalBits = partialBits + 2;
        if (finalBits >= 8) {
            this.absorb(new byte[]{(byte)finalInput}, 0, 1);
            finalBits -= 8;
            finalInput >>>= 8;
        }
        return super.doFinal(out, outOff, (byte)finalInput, finalBits);
    }
}

