/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.digest.internal.impl;

import com.jn.langx.security.crypto.digest.internal.impl._AbstractLongDigest;
import com.jn.langx.util.Memoable;
import com.jn.langx.util.io.bytes.Bytes;

public final class _SHA512Digest
extends _AbstractLongDigest {
    private static final int DIGEST_LENGTH = 64;

    public _SHA512Digest() {
    }

    public _SHA512Digest(_SHA512Digest t) {
        super(t);
    }

    public _SHA512Digest(byte[] encodedState) {
        this.restoreState(encodedState);
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-512";
    }

    @Override
    public int getDigestSize() {
        return 64;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.finish();
        Bytes.longToBigEndian(this.H1, out, outOff);
        Bytes.longToBigEndian(this.H2, out, outOff + 8);
        Bytes.longToBigEndian(this.H3, out, outOff + 16);
        Bytes.longToBigEndian(this.H4, out, outOff + 24);
        Bytes.longToBigEndian(this.H5, out, outOff + 32);
        Bytes.longToBigEndian(this.H6, out, outOff + 40);
        Bytes.longToBigEndian(this.H7, out, outOff + 48);
        Bytes.longToBigEndian(this.H8, out, outOff + 56);
        this.reset();
        return 64;
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = 7640891576956012808L;
        this.H2 = -4942790177534073029L;
        this.H3 = 4354685564936845355L;
        this.H4 = -6534734903238641935L;
        this.H5 = 5840696475078001361L;
        this.H6 = -7276294671716946913L;
        this.H7 = 2270897969802886507L;
        this.H8 = 6620516959819538809L;
    }

    @Override
    public Memoable copy() {
        return new _SHA512Digest(this);
    }

    @Override
    public void reset(Memoable other) {
        _SHA512Digest d = (_SHA512Digest)other;
        this.copyIn(d);
    }

    public byte[] getEncodedState() {
        byte[] encoded = new byte[this.getEncodedStateSize()];
        super.populateState(encoded);
        return encoded;
    }
}

