/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.key.spec.pem;

import com.jn.langx.codec.base64.Base64;
import com.jn.langx.registry.GenericRegistry;
import com.jn.langx.security.SecurityException;
import com.jn.langx.security.Securitys;
import com.jn.langx.security.crypto.JCAEStandardName;
import com.jn.langx.security.crypto.cipher.CipherAlgorithmPadding;
import com.jn.langx.security.crypto.cipher.Ciphers;
import com.jn.langx.security.crypto.cipher.Symmetrics;
import com.jn.langx.security.crypto.digest.MessageDigests;
import com.jn.langx.security.crypto.key.PKIs;
import com.jn.langx.security.crypto.key.spec.KeyFileFormatException;
import com.jn.langx.security.crypto.key.spec.der.DerParser;
import com.jn.langx.security.crypto.key.spec.der.DsaPrivateKeySpecParser;
import com.jn.langx.security.crypto.key.spec.der.EcPrivateKeySpecParser;
import com.jn.langx.security.crypto.key.spec.der.RsaPkcs1PrivateKeySpecParser;
import com.jn.langx.security.crypto.key.spec.pem.PemKeyFormat;
import com.jn.langx.util.Chars;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Supplier0;
import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.io.file.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class PEMs
extends Securitys {
    private static final String HEADER = "-----BEGIN";
    public static final String PKCS1 = "PKCS#1";
    public static final String PKCS8 = "PKCS#8";
    public static final String PKCS8_ENCRYPTED = "PKCS#8:ENCRYPTED";
    public static final String OPENSSL_DSA = "OPENSSL::DSA";
    public static final String OPENSSL_DSA_PARAMS = "OPENSSL::DSA::PARAMS";
    public static final String OPENSSL_EC = "OPENSSL::EC";
    public static final String OPENSSL_EC_PARAMS = "OPENSSL::EC::PARAMS";
    private static final GenericRegistry<PemKeyFormat> DEFAULT_PEM_STYLE_REGISTRY = new GenericRegistry(Collects.emptyHashMap(true));

    private static String newKeyFlagLine(String ... keywords) {
        return "-----" + Strings.join(" ", keywords) + "-----";
    }

    public static GenericRegistry<PemKeyFormat> getDefaultPemStyleRegistry() {
        return DEFAULT_PEM_STYLE_REGISTRY;
    }

    private PEMs() {
        throw new IllegalStateException("Utility class should not be instantiated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey readPrivateKey(File keyFile, Supplier0<char[]> passwordSupplier) throws GeneralSecurityException {
        PrivateKey privateKey;
        BufferedReader bReader = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = Files.openInputStream(keyFile);
            bReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, Charsets.UTF_8));
            privateKey = PEMs.readPrivateKey(bReader, passwordSupplier);
        }
        catch (Throwable throwable) {
            IOs.close(fileInputStream);
            IOs.close(bReader);
            throw throwable;
        }
        IOs.close(fileInputStream);
        IOs.close(bReader);
        return privateKey;
    }

    public static PrivateKey readPrivateKey(BufferedReader pemKeyFile, Supplier0<char[]> passwordSupplier) throws GeneralSecurityException {
        try {
            String line = pemKeyFile.readLine();
            while (null != line && !line.startsWith(HEADER)) {
                line = pemKeyFile.readLine();
            }
            if (null == line) {
                throw new KeyFileFormatException("Error parsing Private Key,file is empty");
            }
            if (((PemKeyFormat)DEFAULT_PEM_STYLE_REGISTRY.get(PKCS8_ENCRYPTED)).getHeader().equals(line.trim())) {
                char[] password = passwordSupplier.get();
                if (password == null) {
                    throw new KeyFileFormatException("Cannot read encrypted key without a password");
                }
                return PEMs.parsePKCS8Encrypted(pemKeyFile, password);
            }
            if (((PemKeyFormat)DEFAULT_PEM_STYLE_REGISTRY.get(PKCS8)).getHeader().equals(line.trim())) {
                return PEMs.parsePKCS8(pemKeyFile);
            }
            if (((PemKeyFormat)DEFAULT_PEM_STYLE_REGISTRY.get(PKCS1)).getHeader().equals(line.trim())) {
                return PEMs.parsePKCS1Rsa(pemKeyFile, passwordSupplier);
            }
            if (((PemKeyFormat)DEFAULT_PEM_STYLE_REGISTRY.get(OPENSSL_DSA)).getHeader().equals(line.trim())) {
                return PEMs.parseOpenSslDsa(pemKeyFile, passwordSupplier);
            }
            if (((PemKeyFormat)DEFAULT_PEM_STYLE_REGISTRY.get(OPENSSL_DSA_PARAMS)).getHeader().equals(line.trim())) {
                return PEMs.parseOpenSslDsa(PEMs.removeDsaHeaders(pemKeyFile), passwordSupplier);
            }
            if (((PemKeyFormat)DEFAULT_PEM_STYLE_REGISTRY.get(OPENSSL_EC)).getHeader().equals(line.trim())) {
                return PEMs.parseOpenSslEC(pemKeyFile, passwordSupplier);
            }
            if (((PemKeyFormat)DEFAULT_PEM_STYLE_REGISTRY.get(OPENSSL_EC_PARAMS)).getHeader().equals(line.trim())) {
                return PEMs.parseOpenSslEC(PEMs.removeECHeaders(pemKeyFile), passwordSupplier);
            }
            throw new KeyFileFormatException("error parsing Private Key, file does not contain a supported key format");
        }
        catch (IOException e) {
            throw new SecurityException("private key file cannot be parsed", e);
        }
    }

    private static BufferedReader removeECHeaders(BufferedReader bReader) throws IOException {
        String line = bReader.readLine();
        String openssl_ec_params_footer = ((PemKeyFormat)DEFAULT_PEM_STYLE_REGISTRY.get(OPENSSL_EC_PARAMS)).getFooter();
        while (line != null && !openssl_ec_params_footer.equals(line.trim())) {
            line = bReader.readLine();
        }
        if (null == line || !openssl_ec_params_footer.equals(line.trim())) {
            throw new IOException("Malformed PEM file, EC Parameters footer is missing");
        }
        String openssl_ec_header = ((PemKeyFormat)DEFAULT_PEM_STYLE_REGISTRY.get(OPENSSL_EC)).getHeader();
        if (!openssl_ec_header.equals(bReader.readLine())) {
            throw new IOException("Malformed PEM file, EC Key header is missing");
        }
        return bReader;
    }

    private static BufferedReader removeDsaHeaders(BufferedReader bReader) throws IOException {
        String line = bReader.readLine();
        String openssl_dsa_header = ((PemKeyFormat)DEFAULT_PEM_STYLE_REGISTRY.get(OPENSSL_DSA)).getHeader();
        String openssl_dsa_params_footer = ((PemKeyFormat)DEFAULT_PEM_STYLE_REGISTRY.get(OPENSSL_DSA_PARAMS)).getFooter();
        while (line != null && !openssl_dsa_params_footer.equals(line.trim())) {
            line = bReader.readLine();
        }
        if (null == line || !openssl_dsa_params_footer.equals(line.trim())) {
            throw new IOException("Malformed PEM file, DSA Parameters footer is missing");
        }
        if (!openssl_dsa_header.equals(bReader.readLine())) {
            throw new IOException("Malformed PEM file, DSA Key header is missing");
        }
        return bReader;
    }

    private static PrivateKey parsePKCS8(BufferedReader bReader) throws IOException {
        StringBuilder sb = new StringBuilder();
        String line = bReader.readLine();
        String pkcs8_footer = ((PemKeyFormat)DEFAULT_PEM_STYLE_REGISTRY.get(PKCS8)).getFooter();
        while (line != null && !pkcs8_footer.equals(line.trim())) {
            sb.append(line.trim());
            line = bReader.readLine();
        }
        if (null == line || !pkcs8_footer.equals(line.trim())) {
            throw new IOException("Malformed PEM file, PEM footer is invalid or missing");
        }
        byte[] keyBytes = Base64.decodeBase64(sb.toString());
        String keyAlgo = PEMs.getKeyAlgorithmIdentifier(keyBytes);
        return PKIs.createPrivateKey(keyAlgo, null, new PKCS8EncodedKeySpec(keyBytes));
    }

    private static PrivateKey parseOpenSslEC(BufferedReader bReader, Supplier0<char[]> passwordSupplier) throws IOException, GeneralSecurityException {
        StringBuilder sb = new StringBuilder();
        String line = bReader.readLine();
        HashMap<String, String> pemHeaders = new HashMap<String, String>();
        String openssl_ec_footer = ((PemKeyFormat)DEFAULT_PEM_STYLE_REGISTRY.get(OPENSSL_EC)).getFooter();
        while (line != null && !openssl_ec_footer.equals(line.trim())) {
            if (line.contains(":")) {
                String[] header = line.split(":");
                pemHeaders.put(header[0].trim(), header[1].trim());
            } else {
                sb.append(line.trim());
            }
            line = bReader.readLine();
        }
        if (null == line || !openssl_ec_footer.equals(line.trim())) {
            throw new IOException("Malformed PEM file, PEM footer is invalid or missing");
        }
        byte[] keyBytes = PEMs.possiblyDecryptPKCS1Key(pemHeaders, sb.toString(), passwordSupplier);
        ECPrivateKeySpec ecSpec = new EcPrivateKeySpecParser().parse(keyBytes);
        return PKIs.createPrivateKey("EC", null, ecSpec);
    }

    private static PrivateKey parsePKCS1Rsa(BufferedReader bReader, Supplier0<char[]> passwordSupplier) throws IOException, GeneralSecurityException {
        StringBuilder sb = new StringBuilder();
        String line = bReader.readLine();
        HashMap<String, String> pemHeaders = new HashMap<String, String>();
        String pkcs1_footer = ((PemKeyFormat)DEFAULT_PEM_STYLE_REGISTRY.get(PKCS1)).getFooter();
        while (line != null && !pkcs1_footer.equals(line.trim())) {
            if (line.contains(":")) {
                String[] header = line.split(":");
                pemHeaders.put(header[0].trim(), header[1].trim());
            } else {
                sb.append(line.trim());
            }
            line = bReader.readLine();
        }
        if (null == line || !pkcs1_footer.equals(line.trim())) {
            throw new IOException("Malformed PEM file, PEM footer is invalid or missing");
        }
        byte[] keyBytes = PEMs.possiblyDecryptPKCS1Key(pemHeaders, sb.toString(), passwordSupplier);
        RSAPrivateCrtKeySpec spec = new RsaPkcs1PrivateKeySpecParser().parse(keyBytes);
        return PKIs.createPrivateKey("RSA", null, spec);
    }

    private static PrivateKey parseOpenSslDsa(BufferedReader bReader, Supplier0<char[]> passwordSupplier) throws IOException, GeneralSecurityException {
        StringBuilder sb = new StringBuilder();
        String line = bReader.readLine();
        HashMap<String, String> pemHeaders = new HashMap<String, String>();
        String openssl_dsa_footer = ((PemKeyFormat)DEFAULT_PEM_STYLE_REGISTRY.get(OPENSSL_DSA)).getFooter();
        while (line != null && !openssl_dsa_footer.equals(line.trim())) {
            if (line.contains(":")) {
                String[] header = line.split(":");
                pemHeaders.put(header[0].trim(), header[1].trim());
            } else {
                sb.append(line.trim());
            }
            line = bReader.readLine();
        }
        if (null == line || !openssl_dsa_footer.equals(line.trim())) {
            throw new IOException("Malformed PEM file, PEM footer is invalid or missing");
        }
        byte[] keyBytes = PEMs.possiblyDecryptPKCS1Key(pemHeaders, sb.toString(), passwordSupplier);
        DSAPrivateKeySpec spec = new DsaPrivateKeySpecParser().parse(keyBytes);
        return PKIs.createPrivateKey("DSA", null, spec);
    }

    private static PrivateKey parsePKCS8Encrypted(BufferedReader bReader, char[] keyPassword) throws IOException, GeneralSecurityException {
        StringBuilder sb = new StringBuilder();
        String line = bReader.readLine();
        String pkcs8_encrypted_footer = ((PemKeyFormat)DEFAULT_PEM_STYLE_REGISTRY.get(PKCS8_ENCRYPTED)).getFooter();
        while (line != null && !pkcs8_encrypted_footer.equals(line.trim())) {
            sb.append(line.trim());
            line = bReader.readLine();
        }
        if (null == line || !pkcs8_encrypted_footer.equals(line.trim())) {
            throw new IOException("Malformed PEM file, PEM footer is invalid or missing");
        }
        byte[] keyBytes = Base64.decodeBase64(sb.toString());
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(keyBytes);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(encryptedPrivateKeyInfo.getAlgName());
        SecretKey secretKey = secretKeyFactory.generateSecret(new PBEKeySpec(keyPassword));
        Arrays.fill(keyPassword, '\u0000');
        Cipher cipher = Cipher.getInstance(encryptedPrivateKeyInfo.getAlgName());
        cipher.init(2, (Key)secretKey, encryptedPrivateKeyInfo.getAlgParameters());
        PKCS8EncodedKeySpec keySpec = encryptedPrivateKeyInfo.getKeySpec(cipher);
        String keyAlgo = PEMs.getKeyAlgorithmIdentifier(keySpec.getEncoded());
        return PKIs.createPrivateKey(keyAlgo, null, keySpec);
    }

    private static byte[] possiblyDecryptPKCS1Key(Map<String, String> pemHeaders, String keyContents, Supplier0<char[]> passwordSupplier) throws GeneralSecurityException, IOException {
        byte[] keyBytes = Base64.decodeBase64(keyContents);
        String procType = pemHeaders.get("Proc-Type");
        if ("4,ENCRYPTED".equals(procType)) {
            String encryptionParameters = pemHeaders.get("DEK-Info");
            if (null == encryptionParameters) {
                throw new IOException("Malformed PEM File, DEK-Info header is missing");
            }
            char[] password = passwordSupplier.get();
            if (password == null) {
                throw new IOException("cannot read encrypted key without a password");
            }
            Cipher cipher = PEMs.getCipherFromParameters(encryptionParameters, password);
            return cipher.doFinal(keyBytes);
        }
        return keyBytes;
    }

    private static Cipher getCipherFromParameters(String dekHeaderValue, char[] password) throws GeneralSecurityException, IOException {
        SecretKey encryptionKey;
        byte[] key;
        byte[] iv;
        CipherAlgorithmPadding padding = CipherAlgorithmPadding.PKCS5Padding;
        String[] valueTokens = dekHeaderValue.split(",");
        if (valueTokens.length != 2) {
            throw new IOException("Malformed PEM file, DEK-Info PEM header is invalid");
        }
        String algorithm = valueTokens[0];
        String ivString = valueTokens[1];
        try {
            iv = PEMs.hexStringToByteArray(ivString);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Malformed PEM file, DEK-Info IV is invalid", e);
        }
        if ("DES-CBC".equals(algorithm)) {
            key = PEMs.generateOpenSslKey(password, iv, 8);
            encryptionKey = new SecretKeySpec(key, JCAEStandardName.DES.getName());
        } else if ("DES-EDE3-CBC".equals(algorithm)) {
            key = PEMs.generateOpenSslKey(password, iv, 24);
            encryptionKey = PKIs.createSecretKey(JCAEStandardName.DESede, key);
        } else if ("AES-128-CBC".equals(algorithm)) {
            key = PEMs.generateOpenSslKey(password, iv, 16);
            encryptionKey = new SecretKeySpec(key, "AES");
        } else if ("AES-192-CBC".equals(algorithm)) {
            key = PEMs.generateOpenSslKey(password, iv, 24);
            encryptionKey = new SecretKeySpec(key, "AES");
        } else if ("AES-256-CBC".equals(algorithm)) {
            key = PEMs.generateOpenSslKey(password, iv, 32);
            encryptionKey = new SecretKeySpec(key, "AES");
        } else {
            throw new GeneralSecurityException("Private Key encrypted with unsupported algorithm [" + algorithm + "]");
        }
        String transformation = Ciphers.createAlgorithmTransformation(encryptionKey.getAlgorithm(), Symmetrics.MODE.CBC.name(), padding);
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(2, (Key)encryptionKey, new IvParameterSpec(iv));
        return cipher;
    }

    private static byte[] generateOpenSslKey(char[] password, byte[] salt, int keyLength) {
        int bytesToCopy;
        byte[] passwordBytes = Chars.toUtf8Bytes(password);
        MessageDigest md5 = MessageDigests.newDigest("md5");
        Preconditions.checkNotNull(md5);
        byte[] key = new byte[keyLength];
        for (int copied = 0; copied < keyLength; copied += bytesToCopy) {
            int remaining = keyLength - copied;
            md5.update(passwordBytes, 0, passwordBytes.length);
            md5.update(salt, 0, 8);
            byte[] tempDigest = md5.digest();
            bytesToCopy = Math.min(remaining, 16);
            System.arraycopy(tempDigest, 0, key, copied, bytesToCopy);
            if (remaining == 0) break;
            md5.update(tempDigest, 0, 16);
        }
        Arrays.fill(passwordBytes, (byte)0);
        return key;
    }

    private static byte[] hexStringToByteArray(String hexString) {
        int len = hexString.length();
        if (len % 2 == 0) {
            byte[] data = new byte[len / 2];
            for (int i = 0; i < len; i += 2) {
                int k = Character.digit(hexString.charAt(i), 16);
                int l = Character.digit(hexString.charAt(i + 1), 16);
                if (k == -1 || l == -1) {
                    throw new IllegalStateException("String [" + hexString + "] is not hexadecimal");
                }
                data[i / 2] = (byte)((k << 4) + l);
            }
            return data;
        }
        throw new IllegalStateException("Hexadecimal string [" + hexString + "] has odd length and cannot be converted to a byte array");
    }

    private static String getKeyAlgorithmIdentifier(byte[] keyBytes) throws IOException, SecurityException {
        DerParser parser = new DerParser(keyBytes);
        DerParser.Asn1Object sequence = parser.readAsn1Object();
        parser = sequence.getParser();
        parser.readAsn1Object().getInteger();
        DerParser.Asn1Object algSequence = parser.readAsn1Object();
        parser = algSequence.getParser();
        String oidString = parser.readAsn1Object().getOid();
        if ("1.2.840.10040.4.1".equals(oidString)) {
            return "DSA";
        }
        if ("1.2.840.113549.1.1.1".equals(oidString)) {
            return "RSA";
        }
        if ("1.2.840.10045.2.1".equals(oidString)) {
            return "EC";
        }
        throw new SecurityException("Error parsing key algorithm identifier. Algorithm with OID [" + oidString + "] is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Certificate> readCertificates(Collection<File> certFiles) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ArrayList<Certificate> certificates = new ArrayList<Certificate>(certFiles.size());
        for (File path : certFiles) {
            FileInputStream input = null;
            try {
                input = Files.openInputStream(path);
                if (input == null) continue;
                Collection<? extends Certificate> parsed = certFactory.generateCertificates(input);
                if (parsed.isEmpty()) {
                    throw new SecurityException("failed to parse any certificates from [" + Files.getCanonicalPath(path) + "]");
                }
                certificates.addAll(parsed);
            }
            finally {
                IOs.close(input);
            }
        }
        return certificates;
    }

    static {
        DEFAULT_PEM_STYLE_REGISTRY.register(new PemKeyFormat(PKCS1, PEMs.newKeyFlagLine("BEGIN", "RSA", "PRIVATE KEY"), PEMs.newKeyFlagLine("END", "RSA", "PRIVATE KEY")));
        DEFAULT_PEM_STYLE_REGISTRY.register(new PemKeyFormat(PKCS8, PEMs.newKeyFlagLine("BEGIN", "PRIVATE KEY"), PEMs.newKeyFlagLine("END", "PRIVATE KEY")));
        DEFAULT_PEM_STYLE_REGISTRY.register(new PemKeyFormat(PKCS8_ENCRYPTED, PEMs.newKeyFlagLine("BEGIN", "ENCRYPTED", "PRIVATE KEY"), PEMs.newKeyFlagLine("END", "ENCRYPTED", "PRIVATE KEY")));
        DEFAULT_PEM_STYLE_REGISTRY.register(new PemKeyFormat(OPENSSL_DSA, PEMs.newKeyFlagLine("BEGIN", "DSA", "PRIVATE KEY"), PEMs.newKeyFlagLine("END", "DSA", "PRIVATE KEY")));
        DEFAULT_PEM_STYLE_REGISTRY.register(new PemKeyFormat(OPENSSL_DSA_PARAMS, PEMs.newKeyFlagLine("BEGIN", "DSA", "PARAMETERS"), PEMs.newKeyFlagLine("END", "DSA", "PARAMETERS")));
        DEFAULT_PEM_STYLE_REGISTRY.register(new PemKeyFormat(OPENSSL_EC, PEMs.newKeyFlagLine("BEGIN", "EC", "PRIVATE KEY"), PEMs.newKeyFlagLine("END", "EC", "PRIVATE KEY")));
        DEFAULT_PEM_STYLE_REGISTRY.register(new PemKeyFormat(OPENSSL_EC_PARAMS, PEMs.newKeyFlagLine("BEGIN", "EC", "PARAMETERS"), PEMs.newKeyFlagLine("END", "EC", "PARAMETERS")));
        DEFAULT_PEM_STYLE_REGISTRY.init();
    }
}

