/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.key.spec.pem;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.codec.base64.Base64;
import com.jn.langx.codec.hex.Hex;
import com.jn.langx.io.resource.ByteArrayResource;
import com.jn.langx.io.resource.InputStreamResource;
import com.jn.langx.io.resource.Resource;
import com.jn.langx.io.resource.Resources;
import com.jn.langx.io.stream.StringBuilderWriter;
import com.jn.langx.security.Securitys;
import com.jn.langx.security.crypto.key.spec.KeyEncoding;
import com.jn.langx.security.crypto.key.spec.KeyFileFormatException;
import com.jn.langx.security.crypto.key.spec.pem.PEMs;
import com.jn.langx.security.crypto.key.spec.pem.PemKeyFormat;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.io.LineDelimiter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;

public class PemFileIOs
extends Securitys {
    public static byte[] readKey(File file) {
        return PemFileIOs.readKey(Resources.loadFileResource(file));
    }

    public static byte[] readKey(File file, KeyEncoding encoding) {
        return PemFileIOs.readKey(Resources.loadFileResource(file), encoding);
    }

    public static byte[] readKey(Resource resource) {
        return PemFileIOs.readKey(resource, KeyEncoding.BASE64);
    }

    public static byte[] readKey(Resource resource, KeyEncoding encoding) {
        try {
            byte[] bytes;
            String content = PemFileIOs.readKeyAsString(resource);
            if (Emptys.isEmpty(content)) {
                throw new NullPointerException();
            }
            encoding = Objs.useValueIfNull(encoding, KeyEncoding.BASE64);
            switch (encoding) {
                case BASE64: {
                    bytes = Base64.decodeBase64(content);
                    break;
                }
                default: {
                    bytes = content.getBytes(Charsets.UTF_8);
                }
            }
            return bytes;
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException(ex);
        }
    }

    public static String readKeyAsString(byte[] bytes) {
        return PemFileIOs.readKeyAsString(new ByteArrayResource(bytes));
    }

    public static String readKeyAsString(InputStream inputStream) {
        return PemFileIOs.readKeyAsString(new InputStreamResource(inputStream));
    }

    public static String readKeyAsString(Resource resource) {
        Preconditions.checkNotNull(resource);
        String filepath = resource.toString();
        BufferedReader bufferedReader = null;
        StringBuilder builder = new StringBuilder(2048);
        try {
            String line;
            InputStream inputStream = resource.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Charsets.UTF_8));
            boolean beginLineFound = false;
            boolean endLineFound = false;
            while ((line = bufferedReader.readLine()) != null && !endLineFound) {
                if ((line = line.trim()).isEmpty()) continue;
                if (line.startsWith("-----") && line.endsWith("-----")) {
                    if (line.startsWith("-----BEGIN")) {
                        if (!beginLineFound) {
                            beginLineFound = true;
                            continue;
                        }
                        throw new KeyFileFormatException(StringTemplates.formatWithPlaceholder("error format key file : {}", filepath));
                    }
                    if (line.startsWith("-----END")) {
                        endLineFound = true;
                        continue;
                    }
                    throw new KeyFileFormatException(StringTemplates.formatWithPlaceholder("error format key file : {}", filepath));
                }
                builder.append(line);
            }
        }
        catch (IOException ex) {
            try {
                throw Throwables.wrapAsRuntimeException(ex);
            }
            catch (Throwable throwable) {
                IOs.close(bufferedReader);
                throw throwable;
            }
        }
        IOs.close(bufferedReader);
        if (builder.length() < 1) {
            throw new KeyFileFormatException(StringTemplates.formatWithPlaceholder("error format key file : {}", filepath));
        }
        return builder.toString();
    }

    @Deprecated
    public static String readKeyFile(Resource resource) {
        return PemFileIOs.readKeyAsString(resource);
    }

    public static void writeKey(@NonNull Key key, @NonNull File file) throws IOException {
        PemFileIOs.writeKey(key, file, null);
    }

    public static void writeKey(@NonNull Key key, @NonNull File file, KeyEncoding encoding) throws IOException {
        PemFileIOs.writeKey(key, file, encoding, null, null);
    }

    public static void writeKey(@NonNull Key key, @NonNull File file, KeyEncoding encoding, @Nullable String headerLine, @Nullable String footerLine) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            PemFileIOs.writeKey(key, (OutputStream)out, encoding, headerLine, footerLine);
        }
        catch (Throwable ex) {
            try {
                throw Throwables.wrapAsRuntimeException(ex);
            }
            catch (Throwable throwable) {
                IOs.close(out);
                throw throwable;
            }
        }
        IOs.close(out);
    }

    public static void writeKey(@NonNull Key key, @NonNull OutputStream outputStream, KeyEncoding encoding, @Nullable String headerLine, @Nullable String footerLine) throws IOException {
        encoding = encoding == null ? KeyEncoding.BASE64 : encoding;
        PemKeyFormat keyFormat = null;
        if (key instanceof PrivateKey) {
            if (key instanceof RSAPrivateCrtKey) {
                keyFormat = (PemKeyFormat)PEMs.getDefaultPemStyleRegistry().get("PKCS#1");
            } else if (key instanceof DSAPrivateKey) {
                keyFormat = (PemKeyFormat)PEMs.getDefaultPemStyleRegistry().get("OPENSSL::DSA");
            } else if (key instanceof ECPrivateKey) {
                keyFormat = (PemKeyFormat)PEMs.getDefaultPemStyleRegistry().get("OPENSSL::EC");
            } else if ("PKCS#8".equals(key.getFormat())) {
                keyFormat = (PemKeyFormat)PEMs.getDefaultPemStyleRegistry().get("PKCS#8");
            }
        }
        if (keyFormat != null) {
            headerLine = headerLine == null ? keyFormat.getHeader() : headerLine;
            footerLine = footerLine == null ? keyFormat.getFooter() : footerLine;
        }
        PemFileIOs.writeKey(key.getEncoded(), outputStream, encoding, headerLine, footerLine);
    }

    public static void writeKey(byte[] keyBytes, File file) throws IOException {
        PemFileIOs.writeKey(keyBytes, file, null, null, null);
    }

    public static void writeKey(byte[] keyBytes, File file, KeyEncoding encoding) throws IOException {
        PemFileIOs.writeKey(keyBytes, file, encoding, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeKey(byte[] keyBytes, File file, KeyEncoding encoding, String headerLine, String footerLine) throws IOException {
        FileOutputStream out = new FileOutputStream(file, true);
        try {
            PemFileIOs.writeKey(keyBytes, (OutputStream)out, encoding, headerLine, footerLine);
        }
        finally {
            IOs.close(out);
        }
    }

    public static void writeKey(byte[] keyBytes, OutputStream outputStream, KeyEncoding encoding, String headerLine, String footerLine) throws IOException {
        Preconditions.checkNotNull(keyBytes);
        Preconditions.checkNotNull(outputStream);
        PemFileIOs.writeKey(keyBytes, new OutputStreamWriter(outputStream, Charsets.UTF_8), encoding, headerLine, footerLine);
    }

    public static void writeKey(byte[] keyBytes, Writer writer, KeyEncoding encoding, String headLine, String footerLine) throws IOException {
        String encodedKeyString;
        Preconditions.checkNotNull(keyBytes);
        Preconditions.checkNotNull(writer);
        encoding = Objs.useValueIfNull(encoding, KeyEncoding.BASE64);
        writer.write(LineDelimiter.DEFAULT.getValue());
        if (Strings.isNotBlank(headLine)) {
            writer.write(headLine.trim());
            writer.write(LineDelimiter.DEFAULT.getValue());
        }
        switch (encoding) {
            case BASE64: {
                encodedKeyString = Base64.encodeBase64String(keyBytes);
                break;
            }
            case HEX: {
                encodedKeyString = Hex.encodeHexString(keyBytes);
                break;
            }
            default: {
                encodedKeyString = new String(keyBytes, Charsets.UTF_8);
            }
        }
        int offset = 0;
        while (offset < encodedKeyString.length()) {
            int toIndex = offset + 64;
            if (toIndex > encodedKeyString.length()) {
                toIndex = encodedKeyString.length();
            }
            writer.write(encodedKeyString.substring(offset, toIndex));
            writer.write(LineDelimiter.DEFAULT.getValue());
            offset = toIndex;
            writer.flush();
        }
        if (Strings.isNotBlank(footerLine)) {
            writer.write(footerLine.trim());
            writer.write(LineDelimiter.DEFAULT.getValue());
        }
        writer.flush();
    }

    public static void writeKey(byte[] keyBytes, StringBuilder stringBuilder, KeyEncoding encoding, String headerLine, String footerLine) throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter(stringBuilder);
        PemFileIOs.writeKey(keyBytes, writer, encoding, headerLine, footerLine);
    }
}

