/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.key.store;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.security.SecurityException;
import com.jn.langx.security.Securitys;
import com.jn.langx.security.crypto.key.PKIs;
import com.jn.langx.security.crypto.key.store.KeyStoreType;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Lists;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.logging.Loggers;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.crypto.SecretKey;
import org.slf4j.Logger;

public class KeyStores
extends Securitys {
    public static final KeyStoreType KEYSTORE_TYPE_JKS = new KeyStoreType("JKS", "SUN");
    public static final KeyStoreType KEYSTORE_TYPE_JCEKS = new KeyStoreType("JCEKS", "SUNJCE");
    public static final KeyStoreType KEYSTORE_TYPE_PKCS12 = new KeyStoreType("PKCS12", "SUNJCE");
    public static final KeyStoreType KEYSTORE_TYPE_BKS = new KeyStoreType("BKS", "BouncyCastle Provider");
    public static final KeyStoreType KEYSTORE_TYPE_UBER = new KeyStoreType("UBER", "BouncyCastle");

    public static List<KeyStoreType> getAllKeyStoreTypes() {
        Provider[] providers = Security.getProviders();
        return Pipeline.of(providers).map(new Function<Provider, List<KeyStoreType>>(){

            @Override
            public List<KeyStoreType> apply(final Provider provider) {
                return Pipeline.of(provider.stringPropertyNames()).filter(new Predicate<String>(){

                    @Override
                    public boolean test(String propertyName) {
                        return Strings.startsWithIgnoreCase(propertyName, "Alg.Alias.KeyStore.") || Strings.startsWithIgnoreCase(propertyName, "KeyStore.");
                    }
                }).map(new Function<String, String>(){

                    @Override
                    public String apply(String propertyName) {
                        String keystoreType = null;
                        if (Strings.startsWith(propertyName, "Alg.Alias.KeyStore.")) {
                            keystoreType = propertyName.substring("Alg.Alias.KeyStore.".length());
                        } else if (Strings.startsWith(propertyName, "KeyStore.")) {
                            keystoreType = propertyName.substring("KeyStore.".length());
                        }
                        return keystoreType;
                    }
                }).clearNulls().map(new Function<String, KeyStoreType>(){

                    @Override
                    public KeyStoreType apply(String keyStoreType) {
                        return new KeyStoreType(keyStoreType, provider.getName());
                    }
                }).asList();
            }
        }).flatMap(new Function<KeyStoreType, KeyStoreType>(){

            @Override
            public KeyStoreType apply(KeyStoreType input) {
                return input;
            }
        }).asList();
    }

    public static String inferKeyStoreType(File path) {
        String name;
        String string = name = path == null ? "" : path.toString().toLowerCase(Locale.ROOT);
        if (name.endsWith(".p12") || name.endsWith(".pfx") || name.endsWith(".pkcs12")) {
            return "PKCS12";
        }
        return "jks";
    }

    public static KeyStore getEmptyKeyStore(@NonNull String type, @Nullable String provider) {
        try {
            return Strings.isEmpty(provider) ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage(), ex);
        }
    }

    public static KeyStore getKeyStore(@NonNull String type, @Nullable String provider, InputStream inputStream, char[] password) {
        try {
            KeyStore keyStore = KeyStores.getEmptyKeyStore(type, provider);
            keyStore.load(inputStream, password);
            return keyStore;
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyStore(@NonNull String type, @Nullable String provider, File file, char[] password) {
        try {
            KeyStore keyStore;
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                keyStore = KeyStores.getKeyStore(type, provider, inputStream, password);
            }
            catch (Throwable throwable) {
                IOs.close(inputStream);
                throw throwable;
            }
            IOs.close(inputStream);
            return keyStore;
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persist(KeyStore keyStore, File file, @NonNull String password) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            KeyStores.persist(keyStore, (OutputStream)outputStream, password);
        }
        catch (Throwable throwable) {
            IOs.close(outputStream);
            throw throwable;
        }
        IOs.close(outputStream);
    }

    public static void persist(@NonNull KeyStore keyStore, @NonNull OutputStream outputStream, @NonNull String password) {
        try {
            KeyStores.persist(keyStore, outputStream, password.toCharArray());
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage(), ex);
        }
    }

    public static void persist(@NonNull KeyStore keyStore, @NonNull OutputStream outputStream, @NonNull char[] password) {
        try {
            keyStore.store(outputStream, password);
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage(), ex);
        }
    }

    public static KeyPair findKeyPair(@NonNull KeyStore keyStore, String alias, String password) {
        try {
            return KeyStores.findKeyPair(keyStore, alias, password.toCharArray());
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage(), ex);
        }
    }

    public static KeyPair findKeyPair(@NonNull KeyStore keyStore, @NonNull String alias, @NonNull char[] password) {
        try {
            if (!keyStore.containsAlias(alias) && keyStore.isKeyEntry(alias)) {
                return null;
            }
            Key key = keyStore.getKey(alias, password);
            if (key instanceof PrivateKey) {
                PrivateKey privateKey = (PrivateKey)key;
                Certificate certificate = keyStore.getCertificate(alias);
                PublicKey publicKey = certificate.getPublicKey();
                return new KeyPair(publicKey, privateKey);
            }
        }
        catch (Throwable ex) {
            Logger logger = Loggers.getLogger(PKIs.class);
            logger.warn("can't find a valid key pair, the alias is {}", (Object)alias);
        }
        return null;
    }

    public static SecretKey findSecretKey(@NonNull KeyStore keyStore, @NonNull String alias, @NonNull String password) {
        return KeyStores.findSecretKey(keyStore, alias, password.toCharArray());
    }

    public static SecretKey findSecretKey(@NonNull KeyStore keyStore, @NonNull String alias, @NonNull char[] password) {
        try {
            if (!keyStore.containsAlias(alias) && keyStore.isKeyEntry(alias)) {
                return null;
            }
            Key key = keyStore.getKey(alias, password);
            if (key instanceof SecretKey) {
                return (SecretKey)key;
            }
        }
        catch (Throwable ex) {
            Logger logger = Loggers.getLogger(PKIs.class);
            logger.warn("can't find a valid key pair, the alias is {}", (Object)alias);
        }
        return null;
    }

    public static Certificate findCertificate(@NonNull KeyStore keyStore, @NonNull String alias) {
        try {
            if (!keyStore.containsAlias(alias)) {
                return null;
            }
            return keyStore.getCertificate(alias);
        }
        catch (Throwable ex) {
            Logger logger = Loggers.getLogger(PKIs.class);
            logger.warn("can't find a valid certificate, the alias is {}", (Object)alias);
            return null;
        }
    }

    public static List<Certificate> findCertificateChain(@NonNull KeyStore keyStore, @NonNull String alias) {
        try {
            if (!keyStore.containsAlias(alias)) {
                return Lists.immutableList();
            }
            Certificate[] certificates = keyStore.getCertificateChain(alias);
            return Collects.newArrayList(certificates);
        }
        catch (Throwable ex) {
            Logger logger = Loggers.getLogger(PKIs.class);
            logger.warn("can't find a valid certificate, the alias is {}", (Object)alias);
            return Lists.immutableList();
        }
    }

    public static PublicKey findPublicKey(@NonNull KeyStore keyStore, @NonNull String alias) {
        Certificate certificate = KeyStores.findCertificate(keyStore, alias);
        PublicKey publicKey = null;
        if (certificate != null) {
            publicKey = certificate.getPublicKey();
        }
        return publicKey;
    }

    public static void setSecretKey(@NonNull KeyStore keyStore, @NonNull String alias, @NonNull SecretKey secretKey, @NonNull char[] password) {
        try {
            keyStore.setKeyEntry(alias, secretKey, password, null);
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage(), ex);
        }
    }

    public static void setPrivateKey(@NonNull KeyStore keyStore, @NonNull String alias, @NonNull PrivateKey privateKey, @NonNull char[] password, @NonNull List<Certificate> certificateChain) {
        try {
            keyStore.setKeyEntry(alias, privateKey, password, (Certificate[])Collects.toArray(certificateChain, Certificate[].class));
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage(), ex);
        }
    }

    public static void setCertificate(@NonNull KeyStore keyStore, @NonNull String alias, @NonNull Certificate certificate) {
        try {
            keyStore.setCertificateEntry(alias, certificate);
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage(), ex);
        }
    }

    public static Set<X509Certificate> getTrustedCerts(KeyStore ks) {
        HashSet<X509Certificate> set = new HashSet<X509Certificate>();
        try {
            Enumeration<String> e = ks.aliases();
            while (e.hasMoreElements()) {
                Certificate[] certs;
                String alias = e.nextElement();
                if (ks.isCertificateEntry(alias)) {
                    Certificate cert = ks.getCertificate(alias);
                    if (!(cert instanceof X509Certificate)) continue;
                    set.add((X509Certificate)cert);
                    continue;
                }
                if (!ks.isKeyEntry(alias) || (certs = ks.getCertificateChain(alias)) == null || certs.length <= 0 || !(certs[0] instanceof X509Certificate)) continue;
                set.add((X509Certificate)certs[0]);
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return set;
    }
}

