/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.pbe.pbkdf;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.codec.base64.Base64;
import com.jn.langx.codec.hex.Hex;
import com.jn.langx.security.crypto.pbe.pbkdf.PBKDFKeySpec;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objs;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;

public class DerivedPBEKey
extends IvParameterSpec
implements PBEKey,
Cloneable {
    @NonNull
    private PBKDFKeySpec keySpec;
    @NonNull
    private String pbeAlgorithm;
    @Nullable
    private String cipherAlgorithm;
    @NonNull
    private byte[] key;

    public DerivedPBEKey(String pbeAlgorithm, PBKDFKeySpec keySpec, byte[] key) {
        this(pbeAlgorithm, null, keySpec, key, null);
    }

    public DerivedPBEKey(String pbeAlgorithm, PBKDFKeySpec keySpec, byte[] key, byte[] iv) {
        this(pbeAlgorithm, null, keySpec, key, iv);
    }

    public DerivedPBEKey(String pbeAlgorithm, String cipherAlgorithm, PBKDFKeySpec keySpec, byte[] key, byte[] iv) {
        super(Objs.useValueIfEmpty(iv, Emptys.EMPTY_BYTES));
        this.key = key;
        this.pbeAlgorithm = pbeAlgorithm;
        this.cipherAlgorithm = cipherAlgorithm;
        this.keySpec = keySpec;
    }

    public String toString() {
        return StringTemplates.formatWithPlaceholder("salt: {}\nkey: {}\niv: {}", Hex.encodeHexString(this.keySpec.getSalt()), Hex.encodeHexString(this.key), this.getIV() == null ? "" : Hex.encodeHexString(this.getIV()));
    }

    @Override
    public byte[] getEncoded() {
        return this.key;
    }

    @Override
    public String getFormat() {
        return Base64.encodeBase64String(this.key);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public char[] getPassword() {
        return this.keySpec.getPassword();
    }

    @Override
    public byte[] getSalt() {
        return this.keySpec.getSalt();
    }

    @Override
    public int getIterationCount() {
        return this.keySpec.getIterationCount();
    }

    @Override
    public String getAlgorithm() {
        return this.pbeAlgorithm;
    }

    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public PBKDFKeySpec getKeySpec() {
        return this.keySpec;
    }

    public int getKeyBitSize() {
        return this.keySpec.getKeyLength();
    }

    public int getIVBitSize() {
        return this.keySpec.getIvBitSize();
    }

    public String getHashAlgorithm() {
        return this.keySpec.getHashAlgorithm();
    }
}

