/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.pbe.pbkdf;

import com.jn.langx.security.SecurityException;
import com.jn.langx.security.crypto.key.PKIs;
import com.jn.langx.security.crypto.pbe.pbkdf.DerivedPBEKey;
import com.jn.langx.security.crypto.pbe.pbkdf.PBKDF;
import com.jn.langx.security.crypto.pbe.pbkdf.PBKDFKeySpec;
import com.jn.langx.util.collection.Arrs;
import com.jn.langx.util.io.Charsets;
import java.security.MessageDigest;
import java.util.Arrays;

class OpenSSLEvpKDF
implements PBKDF {
    OpenSSLEvpKDF() {
    }

    @Override
    public DerivedPBEKey apply(String pbeAlgorithm, PBKDFKeySpec keySpec) {
        try {
            int keyBytesLength = PKIs.getBytesLength(keySpec.getKeyLength());
            int ivBytesLength = PKIs.getBytesLength(keySpec.getIvBitSize());
            byte[] key = new byte[keyBytesLength];
            byte[] iv = new byte[ivBytesLength];
            int keySizeInWord = keyBytesLength / 4;
            int ivSizeInWord = ivBytesLength / 4;
            int targetKeySizeInWorld = keySizeInWord + ivSizeInWord;
            byte[] derivedBytes = new byte[targetKeySizeInWorld * 4];
            byte[] block = null;
            char[] pswd = Arrs.copy(keySpec.getPassword());
            byte[] passphraseBytes = new String(pswd).getBytes(Charsets.UTF_8);
            Arrays.fill(pswd, '\u0000');
            MessageDigest hasher = MessageDigest.getInstance(keySpec.getHashAlgorithm());
            for (int numberOfDerivedWords = 0; numberOfDerivedWords < targetKeySizeInWorld; numberOfDerivedWords += block.length / 4) {
                if (block != null) {
                    hasher.update(block);
                }
                hasher.update(passphraseBytes);
                block = hasher.digest(keySpec.getSalt());
                hasher.reset();
                for (int i = 1; i < keySpec.getIterationCount(); ++i) {
                    block = hasher.digest(block);
                    hasher.reset();
                }
                System.arraycopy(block, 0, derivedBytes, numberOfDerivedWords * 4, Math.min(block.length, (targetKeySizeInWorld - numberOfDerivedWords) * 4));
            }
            System.arraycopy(derivedBytes, 0, key, 0, keySizeInWord * 4);
            System.arraycopy(derivedBytes, keySizeInWord * 4, iv, 0, ivSizeInWord * 4);
            DerivedPBEKey derivedKey = new DerivedPBEKey(pbeAlgorithm, keySpec, key, iv);
            return derivedKey;
        }
        catch (Throwable e) {
            throw new SecurityException(e);
        }
    }
}

