/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.pbe.pswdenc;

import com.jn.langx.security.crypto.pbe.pswdenc.BCrypt;
import com.jn.langx.security.crypto.pbe.pswdenc.BlowfishSaltGenerator;
import com.jn.langx.security.crypto.pbe.pswdenc.PasswordEncryptor;
import java.security.SecureRandom;

public class BCryptPasswordEncryptor
implements PasswordEncryptor {
    private BlowfishSaltGenerator saltGenerator;

    public BCryptPasswordEncryptor() {
        this(10);
    }

    public BCryptPasswordEncryptor(int log_round) {
        this(log_round, null);
    }

    public BCryptPasswordEncryptor(int log_round, SecureRandom secureRandom) {
        this.saltGenerator = new BlowfishSaltGenerator(log_round, secureRandom);
    }

    @Override
    public String encrypt(String password) {
        String salt = this.saltGenerator.get(16);
        return BCrypt.hashpw(password, salt);
    }

    @Override
    public boolean check(String plainPassword, String encryptedPassword) {
        return BCrypt.checkpw(plainPassword, encryptedPassword);
    }
}

