/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.ext.py;

import com.jn.langx.security.crypto.pbe.pswdenc.PasswordEncryptor;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Arrs;
import com.jn.langx.util.collection.PrimitiveArrays;
import com.jn.langx.util.random.Randoms;

public class DjangoCsrfTokenEncryptor
implements PasswordEncryptor {
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private int secretLength = 32;

    @Override
    public String encrypt(String csrfSecret) {
        Preconditions.checkArgument(this.secretLength == csrfSecret.length(), "invalid django csrf secret");
        String salt = this.getNewCsrfString();
        return this.encrypt(csrfSecret, salt);
    }

    private String encrypt(String csrfSecret, String salt) {
        StringBuilder cipherBuilder = new StringBuilder(this.secretLength * 2);
        for (int i = 0; i < this.secretLength; ++i) {
            int indexOfSecret = Strings.indexOf((CharSequence)ALPHABET, csrfSecret.charAt(i));
            int indexOfSalt = Strings.indexOf((CharSequence)ALPHABET, salt.charAt(i));
            char c = ((Character)Arrs.get(PrimitiveArrays.wrap(ALPHABET.toCharArray()), (indexOfSecret + indexOfSalt) % ALPHABET.length())).charValue();
            cipherBuilder.append(c);
        }
        String cipherText = cipherBuilder.toString();
        return salt + cipherText;
    }

    private String decrypt(String cipherText, String salt) {
        StringBuilder builder = new StringBuilder(this.secretLength * 2);
        for (int i = 0; i < this.secretLength; ++i) {
            int indexOfSecret = Strings.indexOf((CharSequence)ALPHABET, cipherText.charAt(i));
            int indexOfSalt = Strings.indexOf((CharSequence)ALPHABET, salt.charAt(i));
            char c = ((Character)Arrs.get(PrimitiveArrays.wrap(ALPHABET.toCharArray()), indexOfSecret - indexOfSalt)).charValue();
            builder.append(c);
        }
        return builder.toString();
    }

    @Override
    public boolean check(String expectedSecret, String csrfMiddlewareToken) {
        String csrfMiddlewareTokenSecret = this.decrypt(csrfMiddlewareToken);
        return Objs.equals(expectedSecret, csrfMiddlewareTokenSecret);
    }

    public static boolean checkToken(String csrfToken, String csrfMiddlewareToken) {
        DjangoCsrfTokenEncryptor encryptor = new DjangoCsrfTokenEncryptor();
        String csrfTokenSecret = encryptor.decrypt(csrfToken);
        return encryptor.check(csrfTokenSecret, csrfMiddlewareToken);
    }

    private String decrypt(String saltedCipherText) {
        String salt = Strings.substring(saltedCipherText, 0, this.secretLength);
        String cipherText = Strings.substring(saltedCipherText, this.secretLength);
        String secret = this.decrypt(cipherText, salt);
        return secret;
    }

    private String getNewCsrfString() {
        return Randoms.randomString(ALPHABET, this.secretLength);
    }

    private String getNewCsrfSecret() {
        return this.getNewCsrfString();
    }
}

