/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.gm;

import com.jn.langx.annotation.Singleton;
import com.jn.langx.lifecycle.AbstractInitializable;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.registry.GenericRegistry;
import com.jn.langx.security.gm.GmService;
import com.jn.langx.text.properties.PropertiesAccessor;
import com.jn.langx.util.Objs;
import com.jn.langx.util.spi.CommonServiceProvider;
import java.util.LinkedHashMap;
import java.util.List;

@Singleton
public class GMs
extends AbstractInitializable {
    private GenericRegistry<GmService> registry = new GenericRegistry(new LinkedHashMap());
    private static volatile GMs INSTANCE;
    private static final String SM2_C1C3C2_MODE_ENABLE_KEY = "langx.security.gm.SM2.defaultMode.c1c3c2.enabled";

    private GMs() {
        this.init();
    }

    public static final void enableGlobalSM2_C1C3C2() {
        System.setProperty(SM2_C1C3C2_MODE_ENABLE_KEY, "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GMs getGMs() {
        if (INSTANCE != null) return INSTANCE;
        Class<GMs> clazz = GMs.class;
        synchronized (GMs.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new GMs();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public GmService getDefault() {
        List<GmService> serviceList = this.registry.instances();
        if (Objs.isNotEmpty(serviceList)) {
            return serviceList.get(0);
        }
        return null;
    }

    public static boolean sm2DefaultC1C3C2ModeEnabled() {
        boolean sm2DefaultC1C3C2ModeEnabled = new PropertiesAccessor(System.getProperties()).getBoolean(SM2_C1C3C2_MODE_ENABLE_KEY, false);
        return sm2DefaultC1C3C2ModeEnabled;
    }

    @Override
    protected void doInit() throws InitializationException {
        GMs.sm2DefaultC1C3C2ModeEnabled();
        for (GmService gmService : CommonServiceProvider.loadService(GmService.class)) {
            this.registry.register(gmService);
        }
    }

    public GmService getGmService(String name) {
        return (GmService)this.registry.get(name);
    }
}

