/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.masking;

import com.jn.langx.registry.GenericRegistry;
import com.jn.langx.security.masking.Masker;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.spi.CommonServiceProvider;

public class Maskings {
    private static final GenericRegistry<Masker> registry = new GenericRegistry();

    public static String masking(Masker masker, Object obj) {
        Object ret = masker.doTransform(obj);
        return ret;
    }

    public static String masking(String strategy, Object obj) {
        Masker masker = (Masker)registry.get(strategy);
        Preconditions.checkNotNull(masker, "the masker strategy {} not found", strategy);
        return Maskings.masking(masker, obj);
    }

    public static void registerMasker(Masker masker) {
        registry.register(masker);
    }

    private Maskings() {
    }

    static {
        Pipeline.of(new CommonServiceProvider<Masker>().get(Masker.class)).forEach(new Consumer<Masker>(){

            @Override
            public void accept(Masker masker) {
                Maskings.registerMasker(masker);
            }
        });
    }

    public static final class Strategy {
        public static final String PHONE = "phone";
        public static final String STAR_6 = "STAR_6";

        private Strategy() {
        }
    }
}

