/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.ssl;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.security.ssl.SSLProtocolVersion;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Objs;
import java.util.HashMap;
import java.util.List;

public class CipherSuite {
    @NonNull
    private String name;
    @Nullable
    private String alias;
    private String keyExchangeAlgorithm;
    private String authcAlgorithm;
    private String encryptAlgorithm;
    private String macAlgorithm;
    private boolean export;
    private boolean anonymous = false;
    private List<SSLProtocolVersion> protocolVersions;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getKeyExchangeAlgorithm() {
        return this.keyExchangeAlgorithm;
    }

    public void setKeyExchangeAlgorithm(String keyExchangeAlgorithm) {
        this.keyExchangeAlgorithm = keyExchangeAlgorithm;
    }

    public String getAuthcAlgorithm() {
        return this.authcAlgorithm;
    }

    public void setAuthcAlgorithm(String authcAlgorithm) {
        this.authcAlgorithm = authcAlgorithm;
    }

    public String getEncryptAlgorithm() {
        return this.encryptAlgorithm;
    }

    public void setEncryptAlgorithm(String encryptAlgorithm) {
        this.encryptAlgorithm = encryptAlgorithm;
    }

    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public void setMacAlgorithm(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
    }

    public boolean isExport() {
        return this.export;
    }

    public void setExport(boolean export) {
        this.export = export;
    }

    public List<SSLProtocolVersion> getProtocolVersions() {
        return this.protocolVersions;
    }

    public void setProtocolVersions(List<SSLProtocolVersion> protocolVersions) {
        this.protocolVersions = protocolVersions;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public String toString() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", this.name);
        map.put("keyExchangeAlgorithm", Objs.useValueIfEmpty(this.keyExchangeAlgorithm, "NULL"));
        map.put("authcAlgorithm", this.anonymous ? "anon" : Objs.useValueIfEmpty(this.authcAlgorithm, "NULL"));
        map.put("encryptAlgorithm", Objs.useValueIfEmpty(this.encryptAlgorithm, "NULL"));
        map.put("macAlgorithm", Objs.useValueIfEmpty(this.macAlgorithm, "NULL"));
        return StringTemplates.formatWithMap("${name}\tKe=${keyExchangeAlgorithm}\tAu=${authcAlgorithm}\tEnc=${encryptAlgorithm}\tMac=${macAlgorithm}", map);
    }
}

