/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.ssl;

import com.jn.langx.Builder;
import com.jn.langx.security.crypto.key.store.KeyStores;
import com.jn.langx.security.ssl.SSLProtocolVersion;
import com.jn.langx.security.ssl.SSLs;
import com.jn.langx.security.ssl.keymanager.InternalKeyManagerProxy;
import com.jn.langx.security.ssl.keymanager.PrivateKeyAliasChooseStrategy;
import com.jn.langx.security.ssl.trustmanager.InternalTrustManagerProxy;
import com.jn.langx.security.ssl.trustmanager.TrustStrategy;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.enums.Enums;
import com.jn.langx.util.io.IOs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;

public class SSLContextBuilder
implements Builder<SSLContext> {
    private String protocol = SSLs.TLS;
    private final Set<KeyManager> keyManagers = new LinkedHashSet<KeyManager>();
    private final Set<TrustManager> trustManagers = new LinkedHashSet<TrustManager>();
    private SecureRandom secureRandom;

    public static SSLContextBuilder create() {
        return new SSLContextBuilder();
    }

    public SSLContextBuilder setProtocol(String protocol) {
        SSLProtocolVersion protocolVersion = "SSL".equals(protocol = Strings.useValueIfEmpty(protocol, SSLs.TLS)) ? SSLProtocolVersion.SSLv30 : Enums.ofName(SSLProtocolVersion.class, protocol);
        return this.setProtocol(protocolVersion);
    }

    public SSLContextBuilder setProtocol(SSLProtocolVersion protocol) {
        this.protocol = protocol == null ? SSLs.TLS : protocol.getName();
        return this;
    }

    public SSLContextBuilder setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public SSLContextBuilder loadTrustMaterial(KeyStore trustStore, TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmFactory.init(trustStore);
        TrustManager[] tms = tmFactory.getTrustManagers();
        if (tms != null) {
            if (trustStrategy != null) {
                for (int i = 0; i < tms.length; ++i) {
                    TrustManager tm = tms[i];
                    if (!(tm instanceof X509TrustManager)) continue;
                    tms[i] = new InternalTrustManagerProxy((X509TrustManager)tm, trustStrategy);
                }
            }
            Collects.addAll(this.trustManagers, tms);
        }
        return this;
    }

    public SSLContextBuilder loadTrustMaterial(TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException {
        return this.loadTrustMaterial(null, trustStrategy);
    }

    public SSLContextBuilder loadTrustMaterial(File file, char[] storePassword, TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException {
        Preconditions.checkNotNullArgument(file, "Truststore file");
        KeyStore trustStore = KeyStores.getKeyStore(KeyStore.getDefaultType(), null, file, storePassword);
        return this.loadTrustMaterial(trustStore, trustStrategy);
    }

    public SSLContextBuilder loadTrustMaterial(File file, char[] storePassword) throws NoSuchAlgorithmException, KeyStoreException {
        return this.loadTrustMaterial(file, storePassword, null);
    }

    public SSLContextBuilder loadTrustMaterial(File file) throws NoSuchAlgorithmException, KeyStoreException {
        return this.loadTrustMaterial(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContextBuilder loadTrustMaterial(URL url, char[] storePassword, TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException, IOException {
        KeyStore trustStore;
        Preconditions.checkNotNullArgument(url, "Truststore URL");
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
            trustStore = KeyStores.getKeyStore(KeyStore.getDefaultType(), null, inputStream, storePassword);
        }
        finally {
            IOs.close(inputStream);
        }
        return this.loadTrustMaterial(trustStore, trustStrategy);
    }

    public SSLContextBuilder loadTrustMaterial(URL url, char[] storePassword) throws NoSuchAlgorithmException, KeyStoreException, IOException {
        return this.loadTrustMaterial(url, storePassword, null);
    }

    public SSLContextBuilder loadKeyMaterial(KeyStore keystore, char[] keyPassword, PrivateKeyAliasChooseStrategy aliasStrategy) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory kmFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmFactory.init(keystore, keyPassword);
        KeyManager[] kms = kmFactory.getKeyManagers();
        if (kms != null) {
            if (aliasStrategy != null) {
                for (int i = 0; i < kms.length; ++i) {
                    KeyManager km = kms[i];
                    if (!(km instanceof X509ExtendedKeyManager)) continue;
                    kms[i] = new InternalKeyManagerProxy((X509ExtendedKeyManager)km, aliasStrategy);
                }
            }
            Collects.addAll(this.keyManagers, kms);
        }
        return this;
    }

    public SSLContextBuilder loadKeyMaterial(KeyStore keystore, char[] keyPassword) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        return this.loadKeyMaterial(keystore, keyPassword, null);
    }

    public SSLContextBuilder loadKeyMaterial(File file, char[] storePassword, char[] keyPassword, PrivateKeyAliasChooseStrategy aliasStrategy) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        Preconditions.checkNotNullArgument(file, "Keystore file");
        KeyStore identityStore = KeyStores.getKeyStore(KeyStore.getDefaultType(), null, file, storePassword);
        return this.loadKeyMaterial(identityStore, keyPassword, aliasStrategy);
    }

    public SSLContextBuilder loadKeyMaterial(File file, char[] storePassword, char[] keyPassword) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        return this.loadKeyMaterial(file, storePassword, keyPassword, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContextBuilder loadKeyMaterial(URL url, char[] storePassword, char[] keyPassword, PrivateKeyAliasChooseStrategy aliasStrategy) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, IOException {
        KeyStore identityStore;
        Preconditions.checkNotNullArgument(url, "Keystore URL");
        InputStream inputStream = url.openStream();
        try {
            identityStore = KeyStores.getKeyStore(KeyStore.getDefaultType(), null, inputStream, storePassword);
        }
        finally {
            IOs.close(inputStream);
        }
        return this.loadKeyMaterial(identityStore, keyPassword, aliasStrategy);
    }

    public SSLContextBuilder loadKeyMaterial(URL url, char[] storePassword, char[] keyPassword) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, IOException {
        return this.loadKeyMaterial(url, storePassword, keyPassword, null);
    }

    protected void initSSLContext(SSLContext sslcontext, Collection<KeyManager> keyManagers, Collection<TrustManager> trustManagers, SecureRandom secureRandom) throws KeyManagementException {
        sslcontext.init(!keyManagers.isEmpty() ? keyManagers.toArray(new KeyManager[0]) : null, !trustManagers.isEmpty() ? trustManagers.toArray(new TrustManager[0]) : null, secureRandom);
    }

    @Override
    public SSLContext build() {
        try {
            SSLContext sslcontext = SSLContext.getInstance(this.protocol);
            this.initSSLContext(sslcontext, this.keyManagers, this.trustManagers, this.secureRandom);
            return sslcontext;
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException(ex);
        }
    }
}

