/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.ssl;

import com.jn.langx.security.ssl.CipherSuite;
import com.jn.langx.security.ssl.SSLContextBuilder;
import com.jn.langx.security.ssl.SSLInitializationException;
import com.jn.langx.security.ssl.SSLProtocolVersion;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Strings;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;

public class SSLs {
    public static final String TLS = SSLProtocolVersion.TLSv12.getName();

    private SSLs() {
    }

    public static SSLContext defaultSSLContext() throws SSLInitializationException {
        try {
            SSLContext sslcontext = SSLContext.getInstance(TLS);
            sslcontext.init(null, null, null);
            return sslcontext;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SSLInitializationException(ex.getMessage(), ex);
        }
        catch (KeyManagementException ex) {
            throw new SSLInitializationException(ex.getMessage(), ex);
        }
    }

    public static SSLContext systemDefaultSSLContext() throws SSLInitializationException {
        try {
            return SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException ex) {
            return SSLs.defaultSSLContext();
        }
    }

    public static SSLContextBuilder customSSLContext() {
        return SSLContextBuilder.create();
    }

    public static CipherSuite inferCipherSuite(String cipherSuiteName) {
        String authcAlgorithm;
        String keyExchangeAlgorithm;
        int ke_authc_split_index;
        String suiteName = cipherSuiteName;
        String alias = null;
        if ((Strings.startsWith(cipherSuiteName, "TLS_") || Strings.startsWith(cipherSuiteName, "SSL_")) && Objs.length(cipherSuiteName) > 4) {
            cipherSuiteName = Strings.substring(cipherSuiteName, 4);
            if (suiteName.startsWith("SSL_")) {
                alias = "TLS_" + cipherSuiteName;
            }
        } else {
            throw new IllegalArgumentException("illegal cipher suite name:" + cipherSuiteName);
        }
        if (!Strings.contains(cipherSuiteName, "_WITH_")) {
            cipherSuiteName = "NULL_WITH_" + cipherSuiteName;
        }
        String[] parts = Strings.split(cipherSuiteName, "_WITH_");
        String ke_authc_part = parts[0];
        String enc_mac_part = parts[1];
        boolean export = false;
        boolean anonymous = false;
        if (ke_authc_part.endsWith("_EXPORT")) {
            ke_authc_part = Strings.substring(ke_authc_part, 0, ke_authc_part.length() - "_EXPORT".length());
            export = true;
        }
        if ((ke_authc_split_index = Strings.indexOf((CharSequence)ke_authc_part, "_")) < 0) {
            keyExchangeAlgorithm = ke_authc_part;
            authcAlgorithm = ke_authc_part;
        } else {
            keyExchangeAlgorithm = Strings.substring(ke_authc_part, 0, ke_authc_split_index);
            authcAlgorithm = Strings.substring(ke_authc_part, ke_authc_split_index + 1);
        }
        int enc_mac_split_index = Strings.lastIndexOf(enc_mac_part, "_");
        if (enc_mac_split_index < 0) {
            throw new IllegalArgumentException("illegal cipher suite name:" + cipherSuiteName);
        }
        String encryptAlgorithm = Strings.substring(enc_mac_part, 0, enc_mac_split_index);
        String macAlgorithm = Strings.substring(enc_mac_part, enc_mac_split_index + 1);
        if (suiteName.equals("TLS_EMPTY_RENEGOTIATION_INFO_SCSV")) {
            anonymous = true;
            keyExchangeAlgorithm = "SCSV";
            authcAlgorithm = "anon";
            encryptAlgorithm = null;
            macAlgorithm = null;
        }
        authcAlgorithm = Objs.useValueIfEquals(authcAlgorithm, "ANON", "anon");
        CipherSuite cipherSuite = new CipherSuite();
        cipherSuite.setName(suiteName);
        cipherSuite.setAlias(alias);
        cipherSuite.setExport(export);
        cipherSuite.setKeyExchangeAlgorithm(Objs.useValueIfEquals(keyExchangeAlgorithm, "NULL", null));
        cipherSuite.setAuthcAlgorithm(Objs.useValueIfEquals(authcAlgorithm, "NULL", null));
        cipherSuite.setAnonymous(anonymous);
        cipherSuite.setEncryptAlgorithm(Objs.useValueIfEquals(encryptAlgorithm, "NULL", null));
        cipherSuite.setMacAlgorithm(Objs.useValueIfEquals(macAlgorithm, "NULL", null));
        return cipherSuite;
    }
}

