/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text;

import com.jn.langx.text.tokenizer.CommonTokenizer;
import com.jn.langx.text.tokenizer.TokenFactory;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Predicate;
import java.util.List;

public class StrTokenizer
extends CommonTokenizer<String> {
    private List<String> delimiters = Strings.WHITESPACE_CHAR;
    private final int max;
    private int foundDelimiterCount = 0;
    private long lastDelimiterStartPosition = -1L;
    private boolean ignoreCase;

    public StrTokenizer(String str) {
        this(str, new String[]{null});
    }

    public StrTokenizer(String str, String ... delimiters) {
        this(str, false, delimiters);
    }

    public StrTokenizer(String str, boolean returnDelimiter, String ... delimiters) {
        this(str, returnDelimiter, false, delimiters);
    }

    public StrTokenizer(String str, boolean returnDelimiter, int max, String ... delimiters) {
        this(str, returnDelimiter, false, max, delimiters);
    }

    public StrTokenizer(String str, boolean returnDelimiter, boolean ignoreCase, String ... delimiters) {
        this(str, returnDelimiter, ignoreCase, -1, delimiters);
    }

    public StrTokenizer(String str, boolean returnDelimiter, boolean ignoreCase, int max, String ... delimiters) {
        super(str, returnDelimiter);
        this.setDelimiters(Collects.asList(delimiters));
        this.max = max < 0 ? Integer.MAX_VALUE : max;
        this.ignoreCase = ignoreCase;
        this.tokenFactory = new TokenFactory<String>(){

            @Override
            public String get(String tokenContent, Boolean isDelimiter) {
                return tokenContent;
            }
        };
    }

    public void setDelimiters(List<String> delimiters) {
        this.delimiters = Objs.useValueIfEmpty(Pipeline.of(delimiters).clearNulls().asList(), this.delimiters);
    }

    @Override
    protected String getDelimiter(long start, long end) {
        String delimiter = super.getDelimiter(start, end);
        ++this.foundDelimiterCount;
        return delimiter;
    }

    @Override
    protected String getIfDelimiterStart(long position, char c) {
        boolean continueFind;
        boolean bl = continueFind = this.foundDelimiterCount < this.max;
        if (continueFind) {
            String delimiter = this.getIfDelimiterStartInternal(position, c);
            if (delimiter != null && this.lastDelimiterStartPosition != position) {
                this.lastDelimiterStartPosition = position;
            }
            return delimiter;
        }
        return null;
    }

    private String getIfDelimiterStartInternal(final long position, char c) {
        final String s = c + "";
        if (this.delimiters.contains("")) {
            if (this.getBuffer().markValue() < position) {
                return "";
            }
            return null;
        }
        String delimiter = Pipeline.of(this.delimiters).findFirst(new Predicate<String>(){

            @Override
            public boolean test(String delimiter) {
                if (Strings.startsWith(delimiter, s, StrTokenizer.this.ignoreCase)) {
                    if (StrTokenizer.this.getBuffer().limit() - position >= (long)delimiter.length()) {
                        String substring = StrTokenizer.this.getBuffer().substring(position, position + (long)delimiter.length());
                        return Strings.equals(substring, delimiter, StrTokenizer.this.ignoreCase);
                    }
                    return false;
                }
                return false;
            }
        });
        return delimiter;
    }

    public String next(List<String> delimiters) {
        Preconditions.checkNotEmpty(delimiters);
        this.delimiters = delimiters;
        return (String)this.getNext();
    }
}

