/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.text.placeholder.PlaceholderParser;
import com.jn.langx.text.stringtemplate.BeanBasedStyleStringFormatter;
import com.jn.langx.text.stringtemplate.CStyleStringFormatter;
import com.jn.langx.text.stringtemplate.CustomPatternStringFormatter;
import com.jn.langx.text.stringtemplate.IndexStringFormatter;
import com.jn.langx.text.stringtemplate.MapBasedStringFormatter;
import com.jn.langx.text.stringtemplate.PlaceholderStringFormatter;
import com.jn.langx.text.stringtemplate.StringTemplateFormatter;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.function.Function2;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.valuegetter.ValueGetter2;
import java.util.Map;

public class StringTemplates {
    public static String formatWithCStyle(String template, Object ... args) {
        return new CStyleStringFormatter().format(template, args);
    }

    public static Supplier<Object[], String> cStyleSupplier(final String template) {
        return new Supplier<Object[], String>(){

            @Override
            public String get(Object[] params) {
                return StringTemplates.formatWithCStyle(template, params);
            }
        };
    }

    public static String formatWithPlaceholder(String template, Object ... args) {
        return new PlaceholderStringFormatter().format(template, args);
    }

    public static Supplier<Object[], String> placeholderStyleSupplier(final String template) {
        return new Supplier<Object[], String>(){

            @Override
            public String get(Object[] params) {
                return StringTemplates.formatWithPlaceholder(template, params);
            }
        };
    }

    public static String formatWithIndex(String template, Object ... args) {
        return new IndexStringFormatter().format(template, args);
    }

    public static Supplier<Object[], String> indexStyleSupplier(final String template) {
        return new Supplier<Object[], String>(){

            @Override
            public String get(Object[] params) {
                return StringTemplates.formatWithIndex(template, params);
            }
        };
    }

    public static <T> String formatWithBean(String template, T bean) {
        return new BeanBasedStyleStringFormatter().format(template, bean);
    }

    public static Supplier<Object[], String> beanStyleSupplier(final String template) {
        return new Supplier<Object[], String>(){

            @Override
            public String get(Object[] params) {
                return StringTemplates.formatWithBean(template, params);
            }
        };
    }

    public static String formatWithMap(String template, Map<String, ?> map) {
        return StringTemplates.formatWithMap(template, MapBasedStringFormatter.PatternStyle.$, map);
    }

    public static Supplier<Object[], String> mapStyleSupplier(@NonNull String template) {
        return StringTemplates.mapStyleSupplier(template, null);
    }

    public static Supplier<Object[], String> mapStyleSupplier(final @NonNull String template, final @Nullable MapBasedStringFormatter.PatternStyle patternStyle) {
        return new Supplier<Object[], String>(){

            @Override
            public String get(Object[] params) {
                return StringTemplates.formatWithMap(template, patternStyle, Emptys.isNotEmpty(params) ? (Map)params[0] : null);
            }
        };
    }

    public static String formatWithMap(String template, MapBasedStringFormatter.PatternStyle patternStyle, Map<String, ?> map) {
        return new MapBasedStringFormatter(patternStyle).format(template, new Object[]{map});
    }

    public static String format(String template, String variablePattern, Function2<String, Object[], String> valueGetter, Object ... args) {
        return new CustomPatternStringFormatter(variablePattern, valueGetter).format(template, args);
    }

    public static String format(String template, Regexp variablePattern, Function2<String, Object[], String> valueGetter, Object ... args) {
        return new CustomPatternStringFormatter(variablePattern, valueGetter).format(template, args);
    }

    public static String format(String template, final String variableStartFlag, final String variableEndFlag, final Function2<String, Object[], String> valueGetter, final Object ... args) {
        String startFlagPattern = variableStartFlag.replace("$", "\\$").replace("[", "\\[").replace("{", "\\{").replace("(", "\\)");
        String endFlagPattern = variableEndFlag.replace("$", "\\$").replace("]", "\\]").replace("}", "\\}").replace(")", "\\)");
        return StringTemplates.format(template, startFlagPattern + "[\\w\\-]+(\\.[\\w\\-]+)*" + endFlagPattern, new Function2<String, Object[], String>(){

            @Override
            public String apply(String variable, Object[] arguments) {
                if (variable.startsWith(variableStartFlag)) {
                    variable = variable.substring(variableStartFlag.length());
                }
                if (variable.endsWith(variableEndFlag)) {
                    variable = variable.substring(0, variable.length() - variableEndFlag.length());
                }
                return (String)valueGetter.apply(variable, args);
            }
        }, new Object[0]);
    }

    public static String format(String template, Regexp variablePattern, final PlaceholderParser variableValueProvider) {
        return StringTemplates.format(template, variablePattern, new Function2<String, Object[], String>(){

            @Override
            public String apply(String variable, Object[] arguments) {
                return variableValueProvider.parse(variable);
            }
        }, new Object[0]);
    }

    public static String format(String template, String variableStartFlag, String variableEndFlag, final PlaceholderParser variableValueProvider) {
        return StringTemplates.format(template, variableStartFlag, variableEndFlag, new Function2<String, Object[], String>(){

            @Override
            public String apply(String variable, Object[] arguments) {
                return variableValueProvider.parse(variable);
            }
        }, new Object[0]);
    }

    public static String format(String template, String variableStartFlag, String variableEndFlag, final ValueGetter2<String> valueGetter) {
        return StringTemplates.format(template, variableStartFlag, variableEndFlag, new Function2<String, Object[], String>(){

            @Override
            public String apply(String variable, Object[] arguments) {
                return valueGetter.getString(variable);
            }
        }, new Object[0]);
    }

    public static TemplateFluenter fluenter(String template) {
        return new TemplateFluenter(template);
    }

    private StringTemplates() {
    }

    public static final class TemplateFluenter {
        private String template;

        private TemplateFluenter(String template) {
            this.template = template;
        }

        public TemplateFluenter format(StringTemplateFormatter formatter, Object ... args) {
            this.template = formatter.format(this.template, args);
            return this;
        }

        public TemplateFluenter format(String variablePattern, Function2<String, Object[], String> valueGetter, Object ... args) {
            return this.format(new CustomPatternStringFormatter(variablePattern, valueGetter), args);
        }

        public TemplateFluenter format(Regexp variablePattern, Function2<String, Object[], String> valueGetter, Object ... args) {
            return this.format(new CustomPatternStringFormatter(variablePattern, valueGetter), args);
        }

        public TemplateFluenter formatWithIndex(Object ... args) {
            return this.format(new IndexStringFormatter(), args);
        }

        public TemplateFluenter formatWithPlaceHolder(Object ... args) {
            return this.format(new PlaceholderStringFormatter(), args);
        }

        public <T> TemplateFluenter formatWithBean(T bean) {
            return this.format(new BeanBasedStyleStringFormatter(), bean);
        }

        public TemplateFluenter formatWithMap(Map<String, Object> map) {
            return this.format(new MapBasedStringFormatter(), map);
        }

        public String get() {
            return this.template;
        }
    }
}

