/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.dfa;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.collection.Maps;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.function.Supplier0;
import com.jn.langx.util.struct.Holder;
import com.jn.langx.util.struct.Pair;
import java.util.Map;

class SimpleDFA {
    public static final int INVALID_STATE = Integer.MIN_VALUE;
    @NonNull
    Map<Integer, Map<String, Integer>> stateTransactions = Maps.newHashMap();

    SimpleDFA() {
    }

    public void addTransaction(int fromState, String symbol, int toState) {
        Map<String, Integer> transactions = Maps.get(this.stateTransactions, Integer.valueOf(fromState), new Supplier0<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> get() {
                return Maps.newHashMap();
            }
        });
        transactions.put(symbol, toState);
        Maps.putIfAbsent(this.stateTransactions, Integer.valueOf(fromState), transactions);
    }

    public int getNextState(int currentState, String symbol) {
        Map to = Maps.get(this.stateTransactions, Integer.valueOf(currentState), Maps.newImmutableMap());
        return Maps.get(to, symbol, Integer.MIN_VALUE);
    }

    public int transformState(int initState, String ... symbols) {
        final Holder<Integer> currentState = new Holder<Integer>(initState);
        Pipeline.of(symbols).forEach(new Consumer<String>(){

            @Override
            public void accept(String symbol) {
                int next = SimpleDFA.this.getNextState((Integer)currentState.get(), symbol);
                currentState.set(next);
            }
        }, new Predicate<String>(){

            @Override
            public boolean test(String symbol) {
                return (Integer)currentState.get() == Integer.MIN_VALUE;
            }
        });
        return currentState.get();
    }

    public Pair<Integer, Integer> getLastValidState(int initState, String ... symbols) {
        final Holder<Pair<Integer, Integer>> currentState = new Holder<Pair<Integer, Integer>>(new Pair<Integer, Integer>(-1, initState));
        Pipeline.of(symbols).forEach(new Consumer2<Integer, String>(){

            @Override
            public void accept(Integer index, String symbol) {
                Pair indexAndState = (Pair)currentState.get();
                int next = SimpleDFA.this.getNextState((Integer)indexAndState.getValue(), symbol);
                if (next > Integer.MIN_VALUE) {
                    indexAndState.setKey(index);
                    indexAndState.setValue(next);
                }
            }
        }, new Predicate2<Integer, String>(){

            @Override
            public boolean test(Integer index, String symbol) {
                return (Integer)((Pair)currentState.get()).getKey() < index;
            }
        });
        return currentState.get();
    }
}

