/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.fragment;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.io.resource.Resource;
import com.jn.langx.text.fragment.MultilineConfig;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Strings;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.iter.UnmodifiableIterator;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.io.file.Files;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.RegexpMatcher;
import com.jn.langx.util.regexp.Regexps;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.slf4j.Logger;

public class TextLinesFragment
extends UnmodifiableIterator<String>
implements Closeable {
    private static final Logger logger = Loggers.getLogger(TextLinesFragment.class);
    @NonNull
    private BufferedReader reader;
    @Nullable
    private MultilineConfig multiline;
    @Nullable
    private Regexp regexp;
    private boolean eof = false;
    private String nextRecord;
    private String flagLine;
    private List<String> nonFlagLines = Collects.emptyArrayList();

    public TextLinesFragment(String filepath) {
        this(Files.openInputStream(new File(filepath)));
    }

    public TextLinesFragment(Resource resource) throws IOException {
        this(resource.getInputStream());
    }

    public TextLinesFragment(InputStream inputStream) {
        this.reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(inputStream)));
    }

    public void setMultiline(MultilineConfig multiline) {
        if (multiline != null) {
            String pattern = multiline.getPattern();
            if (Objs.isNotEmpty(pattern)) {
                this.multiline = multiline;
            } else {
                this.multiline = null;
                this.regexp = null;
                logger.warn("invalid multiline.pattern: {}", (Object)multiline);
            }
        }
        if (this.multiline != null) {
            this.regexp = Regexps.createRegexp(this.multiline.getPattern());
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.eof) {
            this.nextRecord = this.readRecord();
            return Objs.isNotNull(this.nextRecord);
        }
        IOs.close(this);
        return false;
    }

    @Override
    public String next() {
        String r = this.nextRecord;
        this.nextRecord = null;
        return r;
    }

    private String readLine() {
        String line;
        try {
            line = this.reader.readLine();
        }
        catch (IOException e) {
            throw Throwables.wrapAsRuntimeException(e);
        }
        return line;
    }

    private String readRecord() {
        String record = null;
        if (this.multiline == null) {
            record = this.readLine();
            if (record == null) {
                this.eof = true;
            }
            return record;
        }
        while (record == null) {
            String line = this.readLine();
            if (line == null) {
                if (Objs.isNotEmpty(this.nonFlagLines)) {
                    record = this.concatMultiline();
                    this.nonFlagLines.clear();
                }
                this.eof = true;
                return record;
            }
            RegexpMatcher matcher = this.regexp.matcher(line);
            boolean matches = matcher.matches();
            if (!this.multiline.isNegate()) {
                if (!matches) {
                    if (this.multiline.getMatch() == MultilineConfig.Match.BEFORE) {
                        this.flagLine = line;
                        record = this.concatMultiline();
                    } else {
                        record = this.concatMultiline();
                        this.flagLine = line;
                    }
                    this.nonFlagLines.clear();
                    continue;
                }
                this.nonFlagLines.add(line);
                continue;
            }
            if (!matches) {
                this.nonFlagLines.add(line);
                continue;
            }
            if (this.multiline.getMatch() == MultilineConfig.Match.BEFORE) {
                this.flagLine = line;
                record = this.concatMultiline();
            } else {
                record = this.concatMultiline();
                this.flagLine = line;
            }
            this.nonFlagLines.clear();
        }
        return record;
    }

    private String concatMultiline() {
        if (Emptys.isAllEmpty(this.flagLine, this.nonFlagLines)) {
            return null;
        }
        String noFlagLinesString = Objs.isEmpty(this.nonFlagLines) ? "" : Strings.join(this.multiline.getConcatSeparator(), this.nonFlagLines);
        StringBuilder builder = new StringBuilder(noFlagLinesString.length() + 255);
        if (this.multiline.getMatch() == MultilineConfig.Match.BEFORE) {
            boolean addSeparator;
            if (Strings.isNotEmpty(noFlagLinesString)) {
                builder.append(noFlagLinesString);
            }
            if (addSeparator = Emptys.isNoneEmpty(noFlagLinesString, this.flagLine)) {
                builder.append(this.multiline.getConcatSeparator());
            }
            if (Strings.isNotEmpty(this.flagLine)) {
                builder.append(this.flagLine);
            }
        } else {
            boolean addSeparator;
            if (Strings.isNotEmpty(this.flagLine)) {
                builder.append(this.flagLine);
            }
            if (addSeparator = Emptys.isNoneEmpty(noFlagLinesString, this.flagLine)) {
                builder.append(this.multiline.getConcatSeparator());
            }
            if (Strings.isNotEmpty(noFlagLinesString)) {
                builder.append(noFlagLinesString);
            }
        }
        return builder.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            IOs.close(this.reader);
            this.reader = null;
        }
    }
}

