/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.grok;

import com.jn.langx.Converter;
import com.jn.langx.text.grok.Converters;
import com.jn.langx.text.grok.Discovery;
import com.jn.langx.text.grok.GrokTemplate;
import com.jn.langx.text.grok.Groks;
import com.jn.langx.text.grok.Match;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.regexp.MatcherWatchdog;
import com.jn.langx.util.regexp.Option;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.RegexpMatcher;
import com.jn.langx.util.regexp.Regexps;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Grok
implements GrokTemplate {
    private final String namedRegex;
    private final Map<String, String> namedRegexCollection;
    private final String originalGrokPattern;
    private final Regexp compiledNamedRegex;
    private final Map<String, String> grokPatternDefinition;
    final Set<String> namedGroups;
    final Map<String, Converters.Type> groupTypes;
    final Map<String, Converter> converters;
    private MatcherWatchdog watchdog;
    private Discovery disco;
    private String savedPattern = "";

    public Regexp getCompiledNamedRegex() {
        return this.compiledNamedRegex;
    }

    public Map<String, String> getGrokPatternDefinition() {
        return this.grokPatternDefinition;
    }

    public Set<String> getNamedGroups() {
        return this.namedGroups;
    }

    public Map<String, Converters.Type> getGroupTypes() {
        return this.groupTypes;
    }

    public Map<String, Converter> getConverters() {
        return this.converters;
    }

    public Grok(String pattern, String namedRegex, Map<String, String> namedRegexCollection, Map<String, String> patternDefinitions, String regexpEngine, String defaultTimeZone, MatcherWatchdog watchdog) {
        this.originalGrokPattern = pattern;
        this.namedRegex = namedRegex;
        this.compiledNamedRegex = Regexps.createRegexp(regexpEngine, namedRegex, Option.DEFAULT);
        this.namedRegexCollection = namedRegexCollection;
        this.namedGroups = Groks.getNameGroups(namedRegex);
        this.groupTypes = Converters.getGroupTypes(namedRegexCollection.values());
        this.converters = Converters.getConverters(namedRegexCollection.values(), defaultTimeZone);
        this.grokPatternDefinition = patternDefinitions;
        this.watchdog = watchdog;
    }

    public String getSavedPattern() {
        return this.savedPattern;
    }

    public void setSavedPattern(String savedpattern) {
        this.savedPattern = savedpattern;
    }

    public Map<String, String> getPatterns() {
        return this.grokPatternDefinition;
    }

    public String getNamedRegex() {
        return this.namedRegex;
    }

    public String getOriginalGrokPattern() {
        return this.originalGrokPattern;
    }

    public String getNamedRegexCollectionById(String id) {
        return this.namedRegexCollection.get(id);
    }

    public Map<String, String> getNamedRegexCollection() {
        return this.namedRegexCollection;
    }

    @Override
    public Map<String, Object> extract(String log) {
        Match match = this.match(log);
        return match.capture();
    }

    public List<Map<String, Object>> extract(List<String> logs) {
        List<Map<String, Object>> matched = Collects.emptyArrayList();
        for (String log : logs) {
            matched.add(this.extract(log));
        }
        return matched;
    }

    Match match(CharSequence text) {
        if (this.compiledNamedRegex == null || Strings.isBlank(text)) {
            return Match.EMPTY;
        }
        RegexpMatcher matcher = this.compiledNamedRegex.matcher(text);
        if (this.watchdog != null) {
            this.watchdog.register(matcher);
        }
        Match match = matcher.find() ? new Match(text, this, matcher) : Match.EMPTY;
        if (this.watchdog != null) {
            this.watchdog.unregister(matcher);
        }
        return match;
    }

    private String discover(String input) {
        if (this.disco == null) {
            this.disco = new Discovery(this);
        }
        return this.disco.discover(input);
    }
}

