/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.grok;

import com.jn.langx.lifecycle.AbstractLifecycle;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.text.grok.Grok;
import com.jn.langx.text.grok.GrokException;
import com.jn.langx.text.grok.GrokTemplate;
import com.jn.langx.text.grok.Groks;
import com.jn.langx.text.grok.pattern.DefaultPatternDefinitionRepository;
import com.jn.langx.text.grok.pattern.PatternDefinition;
import com.jn.langx.text.grok.pattern.PatternDefinitionRepository;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.regexp.MatcherWatchdog;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.RegexpMatcher;
import com.jn.langx.util.regexp.Regexps;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class GrokCompiler
extends AbstractLifecycle {
    private PatternDefinitionRepository definitionRepository;
    private String regexpEngine;
    private MatcherWatchdog watchdog;
    private static final Regexp patternLinePattern = Regexps.createRegexp("^([A-z0-9_]+)\\s+(.*)$");

    public void setDefinitionRepository(PatternDefinitionRepository definitionRepository) {
        this.definitionRepository = definitionRepository;
    }

    public Map<String, PatternDefinition> getPatternDefinitions() {
        return this.definitionRepository.getAll();
    }

    public GrokCompiler() {
        this("grok-compiler");
    }

    public GrokCompiler(String name) {
        this(name, null);
    }

    public GrokCompiler(String name, String regexpEngine) {
        this.setName(name);
        this.setRegexpEngine(regexpEngine);
    }

    public void setWatchdog(MatcherWatchdog watchdog) {
        this.watchdog = watchdog;
    }

    public void setRegexpEngine(String regexpEngine) {
        if (Strings.isNotEmpty(regexpEngine) && Regexps.findRegexpEngine(regexpEngine) != null) {
            this.regexpEngine = regexpEngine;
        }
    }

    @Override
    public void init() throws InitializationException {
        if (this.definitionRepository == null) {
            this.definitionRepository = new DefaultPatternDefinitionRepository();
            this.definitionRepository.setName(this.getName());
        }
    }

    @Override
    protected void doStart() {
        this.definitionRepository.startup();
    }

    @Override
    protected void doStop() {
        this.definitionRepository.shutdown();
    }

    public void register(String name, String pattern) {
        name = Objs.requireNonNull(name).trim();
        pattern = Objs.requireNonNull(pattern).trim();
        if (!name.isEmpty() && !pattern.isEmpty()) {
            this.definitionRepository.add(new PatternDefinition(name, pattern));
        }
    }

    public void register(Map<String, String> patternDefinitions) {
        Objs.requireNonNull(patternDefinitions);
        Collects.forEach(patternDefinitions, new Consumer2<String, String>(){

            @Override
            public void accept(String key, String value) {
                GrokCompiler.this.register(key, value);
            }
        });
    }

    public void registerDefaultPatterns() {
        this.registerPatternFromClasspath("/patterns/patterns");
    }

    public void registerPatternFromClasspath(String path) throws GrokException {
        this.registerPatternFromClasspath(path, Charsets.UTF_8);
    }

    public void registerPatternFromClasspath(String path, Charset charset) throws GrokException {
        InputStream inputStream = this.getClass().getResourceAsStream(path);
        try {
            this.register(inputStream, charset);
        }
        catch (IOException ex) {
            throw new GrokException(ex);
        }
    }

    public void register(InputStream input) throws IOException {
        this.register(input, Charsets.UTF_8);
    }

    public void register(InputStream input, Charset charset) throws IOException {
        this.register(new InputStreamReader(input, charset));
    }

    public void register(Reader input) throws IOException {
        try {
            Pipeline.of(IOs.readLines(input)).map(new Function<String, RegexpMatcher>(){

                @Override
                public RegexpMatcher apply(String line) {
                    return patternLinePattern.matcher(line);
                }
            }).filter(new Predicate<RegexpMatcher>(){

                @Override
                public boolean test(RegexpMatcher matcher) {
                    return matcher.matches();
                }
            }).forEach(new Consumer2<Integer, RegexpMatcher>(){

                @Override
                public void accept(Integer key, RegexpMatcher m) {
                    GrokCompiler.this.register(m.group(1), m.group(2));
                }
            });
        }
        finally {
            IOs.close(input);
        }
    }

    public GrokTemplate compile(String pattern) throws IllegalArgumentException {
        return this.compile(pattern, false);
    }

    public GrokTemplate compile(String pattern, boolean namedOnly) throws IllegalArgumentException {
        return this.compile(pattern, TimeZone.getDefault().getID(), namedOnly);
    }

    public GrokTemplate compile(String pattern, String timeZoneId, boolean namedOnly) throws IllegalArgumentException {
        if (Strings.isBlank(pattern)) {
            throw new IllegalArgumentException("{pattern} should not be empty or null");
        }
        String namedRegex = pattern;
        int index = 0;
        int iterationLeft = 1000;
        boolean continueIteration = true;
        Map<String, PatternDefinition> patternDefinitionsRegistry = this.definitionRepository.getAll();
        final HashMap<String, String> patternDefinitions = new HashMap<String, String>();
        Collects.forEach(patternDefinitionsRegistry, new Consumer2<String, PatternDefinition>(){

            @Override
            public void accept(String key, PatternDefinition value) {
                patternDefinitions.put(key, value.getExpr());
            }
        });
        HashMap<String, String> namedRegexCollection = new HashMap<String, String>();
        Set<String> namedGroups = Groks.GROK_PATTERN_NAMED_GROUPS;
        while (continueIteration) {
            continueIteration = false;
            if (iterationLeft <= 0) {
                throw new IllegalArgumentException("Deep recursion pattern compilation of " + pattern);
            }
            --iterationLeft;
            RegexpMatcher matcher = Groks.GROK_PATTERN.matcher(namedRegex);
            while (matcher.find()) {
                String grokName;
                continueIteration = true;
                Map<String, String> group = Regexps.namedGroups(matcher, namedGroups);
                if (group.get("definition") != null) {
                    patternDefinitions.put(group.get("pattern"), group.get("definition"));
                    group.put("name", group.get("name") + "=" + group.get("definition"));
                }
                if (Strings.isBlank(grokName = group.get("name"))) {
                    throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder("invalid grok, missing name: {}", namedRegex));
                }
                int count = Strings.countMatches((CharSequence)namedRegex, "%{" + grokName + "}");
                String _namedRegexp = namedRegex;
                for (int i = 0; i < count; ++i) {
                    String definitionOfPattern = (String)patternDefinitions.get(group.get("pattern"));
                    if (definitionOfPattern == null) {
                        throw new IllegalArgumentException(String.format("No definition for key '%s' found, aborting", group.get("pattern")));
                    }
                    String replacement = StringTemplates.formatWithPlaceholder("(?<name{}>{})", index, definitionOfPattern);
                    String subName = group.get("subname");
                    if (namedOnly && Strings.isEmpty(subName)) {
                        replacement = StringTemplates.formatWithPlaceholder("(?:{})", definitionOfPattern);
                    }
                    String rename = Objs.useValueIfEmpty(subName, grokName);
                    namedRegexCollection.put("name" + index, rename);
                    _namedRegexp = Strings.replace(_namedRegexp, "%{" + grokName + "}", replacement, 1);
                    ++index;
                }
                if (Objs.equals(namedRegex, _namedRegexp)) {
                    continueIteration = false;
                    continue;
                }
                namedRegex = _namedRegexp;
                matcher = Groks.GROK_PATTERN.matcher(namedRegex);
            }
        }
        if (namedRegex.isEmpty()) {
            throw new IllegalArgumentException("Pattern not found");
        }
        return new Grok(pattern, namedRegex, namedRegexCollection, patternDefinitions, this.regexpEngine, timeZoneId, this.watchdog);
    }
}

