/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.grok.pattern;

import com.jn.langx.io.resource.FileResource;
import com.jn.langx.io.resource.Resource;
import com.jn.langx.text.grok.pattern.PatternDefinition;
import com.jn.langx.text.grok.pattern.PatternDefinitionLoader;
import com.jn.langx.text.grok.pattern.PatternDefinitions;
import com.jn.langx.util.collection.Collects;
import java.io.File;
import java.util.Map;

public class PatternDefinitionSingleFileLoader
implements PatternDefinitionLoader {
    private Resource resource;
    private final Map<String, PatternDefinition> cache = Collects.emptyHashMap(true);
    private long lastModified = 0L;

    public PatternDefinitionSingleFileLoader(Resource resource) {
        this.resource = resource;
    }

    @Override
    public Map<String, PatternDefinition> loadAll() {
        this.read();
        return this.cache;
    }

    private void read() {
        boolean needRead = false;
        if (this.resource.exists() && this.resource.isReadable()) {
            File file;
            if (this.cache.isEmpty()) {
                needRead = true;
            } else if (this.resource instanceof FileResource && this.lastModified < (file = ((FileResource)this.resource).getRealResource()).lastModified()) {
                needRead = true;
            }
        }
        if (needRead) {
            this.cache.putAll(PatternDefinitions.readDefinitions(this.resource));
        }
    }

    @Override
    public PatternDefinition load(String id) {
        this.read();
        return this.cache.get(id);
    }
}

