/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.i18n;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.ClassLoaders;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.function.Function2;
import java.util.Locale;
import java.util.ResourceBundle;

public class ResourceBundles {
    private ResourceBundles() {
    }

    public static String getString(@NonNull String basename, @NonNull String key, Object ... args) {
        return ResourceBundles.getString(basename, Locale.getDefault(), ClassLoaders.getDefaultClassLoader(), key, args);
    }

    public static String getString(@NonNull String basename, @NonNull Locale locale, @NonNull String key, Object ... args) {
        return ResourceBundles.getString(basename, locale, ClassLoaders.getDefaultClassLoader(), key, args);
    }

    public static String getString(@NonNull String basename, @NonNull Locale locale, @NonNull ClassLoader classLoader, @NonNull String key, Object ... args) {
        ResourceBundle bundle = ResourceBundle.getBundle(basename, locale, classLoader);
        return ResourceBundles.getString(bundle, key, args);
    }

    public static String getString(final ResourceBundle bundle, String key, Object ... args) {
        if (bundle == null) {
            return null;
        }
        String message = bundle.getString(key);
        if (args == null) {
            args = Emptys.EMPTY_OBJECTS;
        }
        message = StringTemplates.format(message, "${", "}", new Function2<String, Object[], String>(){

            @Override
            public String apply(String variable, Object[] args) {
                return ResourceBundles.getString(bundle, variable, new Object[0]);
            }
        }, new Object[0]);
        message = StringTemplates.formatWithIndex(message, args);
        return message;
    }
}

