/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.ini;

import com.jn.langx.configuration.ConfigurationException;
import com.jn.langx.io.resource.Resources;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.logging.Loggers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.slf4j.Logger;

public class Ini
implements Map<String, Section> {
    private static final String DEFAULT_SECTION_NAME = "";
    private static final String COMMENT_POUND = "#";
    private static final String COMMENT_SEMICOLON = ";";
    private static final String SECTION_PREFIX = "[";
    private static final String SECTION_SUFFIX = "]";
    private static final char ESCAPE_TOKEN = '\\';
    private final Map<String, Section> sections = new LinkedHashMap<String, Section>();

    public Ini() {
    }

    public Ini(Ini defaults) {
        this();
        if (defaults == null) {
            throw new NullPointerException("Defaults cannot be null.");
        }
        Collects.forEach(defaults.sections, new Consumer<Section>(){

            @Override
            public void accept(Section section) {
                Section copy = new Section(section);
                Ini.this.sections.put(section.getName(), copy);
            }
        });
    }

    private static String cleanName(String sectionName) {
        return Strings.useValueIfBlank(sectionName, DEFAULT_SECTION_NAME).trim();
    }

    public static Ini fromResourcePath(String resourcePath) throws ConfigurationException {
        if (!Strings.isNotEmpty(resourcePath)) {
            throw new IllegalArgumentException("Resource Path argument cannot be null or empty.");
        }
        Ini ini = new Ini();
        ini.loadFile(resourcePath);
        return ini;
    }

    protected static boolean isSectionHeader(String line) {
        String s = Strings.useValueIfBlank(line, DEFAULT_SECTION_NAME);
        return s.startsWith(SECTION_PREFIX) && s.endsWith(SECTION_SUFFIX);
    }

    protected static String getSectionName(String line) {
        String s = Strings.useValueIfBlank(line, DEFAULT_SECTION_NAME);
        return Ini.isSectionHeader(s) ? Ini.cleanName(s.substring(1, s.length() - 1)) : null;
    }

    @Override
    public boolean isEmpty() {
        Collection<Section> sections = this.sections.values();
        if (!sections.isEmpty()) {
            return Collects.allMatch(sections, new Predicate<Section>(){

                @Override
                public boolean test(Section section) {
                    return section.isEmpty();
                }
            });
        }
        return true;
    }

    public Set<String> getSectionNames() {
        return Collections.unmodifiableSet(this.sections.keySet());
    }

    public Collection<Section> getSections() {
        return Collections.unmodifiableCollection(this.sections.values());
    }

    public Section getSection(String sectionName) {
        String name = Ini.cleanName(sectionName);
        return this.sections.get(name);
    }

    public Section createSectionIfAbsent(String sectionName) {
        return this.createSectionIfAbsent(sectionName, null);
    }

    public Section createSectionIfAbsent(String sectionName, Section s) {
        String name = Ini.cleanName(sectionName);
        Section section = this.getSection(name);
        if (section == null) {
            section = new Section(name);
            this.sections.put(name, section);
        }
        if (s != null) {
            section.putAll(s);
        }
        return section;
    }

    public Section removeSection(String sectionName) {
        String name = Ini.cleanName(sectionName);
        return this.sections.remove(name);
    }

    public void setSectionProperty(String sectionName, String propertyName, String propertyValue) {
        String name = Ini.cleanName(sectionName);
        Section section = this.getSection(name);
        if (section == null) {
            section = this.createSectionIfAbsent(name);
        }
        section.put(propertyName, propertyValue);
    }

    public String getSectionProperty(String sectionName, String propertyName) {
        Section section = this.getSection(sectionName);
        return section != null ? section.get(propertyName) : null;
    }

    public String getSectionProperty(String sectionName, String propertyName, String defaultValue) {
        String value = this.getSectionProperty(sectionName, propertyName);
        return value != null ? value : defaultValue;
    }

    public void loadFile(String resourcePath) throws ConfigurationException {
        InputStream is = null;
        try {
            is = Resources.loadFileResource(resourcePath).getInputStream();
            this.load(is);
        }
        catch (IOException ioe) {
            throw new ConfigurationException(ioe);
        }
        finally {
            IOs.close(is);
        }
    }

    public void load(String iniConfig) throws ConfigurationException {
        this.load(new StringReader(iniConfig));
    }

    public void load(InputStream is) throws ConfigurationException {
        InputStreamReader isr;
        if (is == null) {
            throw new NullPointerException("InputStream argument cannot be null.");
        }
        try {
            isr = new InputStreamReader(is, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ConfigurationException(ex);
        }
        this.load(isr);
    }

    public void load(Reader reader) {
        String sectionName = DEFAULT_SECTION_NAME;
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuilder sectionContent = new StringBuilder();
        Logger logger = Loggers.getLogger(this.getClass());
        try {
            String rawLine;
            while ((rawLine = bufferedReader.readLine()) != null) {
                String line = Strings.trim(rawLine);
                if (line.startsWith(COMMENT_POUND) || line.startsWith(COMMENT_SEMICOLON)) continue;
                String newSectionName = Ini.getSectionName(line);
                if (newSectionName != null) {
                    this.addSectionIfAbsent(sectionName, sectionContent);
                    sectionContent = new StringBuilder();
                    sectionName = newSectionName;
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Parsing [{}]", (Object)newSectionName);
                    continue;
                }
                sectionContent.append(rawLine).append("\n");
            }
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.addSectionIfAbsent(sectionName, sectionContent);
    }

    public void merge(Map<String, Section> m) {
        Collects.forEach(m, new Consumer2<String, Section>(){

            @Override
            public void accept(String key, Section section) {
                Ini.this.createSectionIfAbsent(key, section);
            }
        });
    }

    private void addSectionIfAbsent(String name, StringBuilder content) {
        Section section;
        String contentString;
        String cleaned;
        if (content.length() > 0 && Strings.isNotEmpty(cleaned = Strings.trim(contentString = content.toString())) && !(section = new Section(name, contentString)).isEmpty()) {
            this.sections.put(name, section);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Ini) {
            Ini ini = (Ini)obj;
            return this.sections.equals(ini.sections);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.sections.hashCode();
    }

    public String toString() {
        if (Emptys.isNotEmpty(this.sections)) {
            final StringBuilder sb = new StringBuilder(256);
            Collects.forEach(this.sections, new Consumer2<String, Section>(){

                @Override
                public void accept(String sectionName, Section section) {
                    sb.append(Ini.SECTION_PREFIX).append(sectionName).append(Ini.SECTION_SUFFIX).append("\n");
                    Collects.forEach(section.props, new Consumer2<String, String>(){

                        @Override
                        public void accept(String key, String value) {
                            sb.append(key).append("=").append(value).append("\n");
                        }
                    });
                    sb.append("\n");
                }
            });
            return sb.toString();
        }
        return "<empty INI>";
    }

    @Override
    public int size() {
        return this.sections.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.sections.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.sections.containsValue(value);
    }

    @Override
    public Section get(Object key) {
        return this.sections.get(key);
    }

    @Override
    public Section put(String key, Section value) {
        return this.sections.put(key, value);
    }

    @Override
    public Section remove(Object key) {
        return this.sections.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Section> m) {
        this.sections.putAll(m);
    }

    @Override
    public void clear() {
        this.sections.clear();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.sections.keySet());
    }

    @Override
    public Collection<Section> values() {
        return Collections.unmodifiableCollection(this.sections.values());
    }

    @Override
    public Set<Map.Entry<String, Section>> entrySet() {
        return Collections.unmodifiableSet(this.sections.entrySet());
    }

    public static class Section
    implements Map<String, String> {
        private final String name;
        private final Map<String, String> props;

        private Section(String name) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            this.name = name;
            this.props = new LinkedHashMap<String, String>();
        }

        private Section(String name, String sectionContent) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            this.name = name;
            Map<String, String> props = Strings.isNotBlank(sectionContent) ? Section.toMapProps(sectionContent) : new LinkedHashMap<String, String>();
            this.props = props;
        }

        private Section(Section defaults) {
            this(defaults.getName());
            this.putAll((Map<? extends String, ? extends String>)defaults.props);
        }

        protected static boolean isContinued(String line) {
            if (Strings.isBlank(line)) {
                return false;
            }
            int length = line.length();
            int backslashCount = 0;
            for (int i = length - 1; i > 0 && line.charAt(i) == '\\'; --i) {
                ++backslashCount;
            }
            return backslashCount % 2 != 0;
        }

        private static boolean isKeyValueSeparatorChar(char c) {
            return Character.isWhitespace(c) || c == ':' || c == '=';
        }

        private static boolean isCharEscaped(CharSequence s, int index) {
            return index > 0 && s.charAt(index) == '\\';
        }

        protected static String[] splitKeyValue(String keyValueLine) {
            String line = Strings.useValueIfBlank(keyValueLine, null);
            if (line == null) {
                return Emptys.EMPTY_STRINGS;
            }
            StringBuilder keyBuffer = new StringBuilder();
            StringBuilder valueBuffer = new StringBuilder();
            boolean buildingKey = true;
            for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (buildingKey) {
                    if (Section.isKeyValueSeparatorChar(c) && !Section.isCharEscaped(line, i)) {
                        buildingKey = false;
                        continue;
                    }
                    if (Section.isCharEscaped(line, i)) continue;
                    keyBuffer.append(c);
                    continue;
                }
                if (valueBuffer.length() == 0 && Section.isKeyValueSeparatorChar(c) && !Section.isCharEscaped(line, i)) continue;
                valueBuffer.append(c);
            }
            String key = Strings.trim(keyBuffer.toString());
            String value = Strings.trim(valueBuffer.toString());
            if (Strings.isNotEmpty(key) && Strings.isNotEmpty(value)) {
                Logger logger = Loggers.getLogger(Ini.class);
                logger.trace("Discovered key/value pair: {} = {}", (Object)key, (Object)value);
                return new String[]{key, value};
            }
            String msg = "Line argument must contain a key and a value.  Only one string token was found.";
            throw new IllegalArgumentException(msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Map<String, String> toMapProps(String content) {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            StringBuilder lineBuffer = new StringBuilder();
            Scanner scanner = null;
            try {
                scanner = new Scanner(content);
                while (scanner.hasNextLine()) {
                    String line = Strings.trim(scanner.nextLine());
                    if (Section.isContinued(line)) {
                        line = line.substring(0, line.length() - 1);
                        lineBuffer.append(line);
                        continue;
                    }
                    lineBuffer.append(line);
                    line = lineBuffer.toString();
                    lineBuffer = new StringBuilder();
                    String[] kvPair = Section.splitKeyValue(line);
                    if (kvPair == null || kvPair.length != 2) continue;
                    props.put(kvPair[0], kvPair[1]);
                }
            }
            catch (Throwable throwable) {
                IOs.close(scanner);
                throw throwable;
            }
            IOs.close(scanner);
            return props;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void clear() {
            this.props.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.props.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.props.containsValue(value);
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.props.entrySet();
        }

        @Override
        public String get(Object key) {
            return this.props.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.props.isEmpty();
        }

        @Override
        public Set<String> keySet() {
            return this.props.keySet();
        }

        @Override
        public String put(String key, String value) {
            return this.props.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
            this.props.putAll(m);
        }

        @Override
        public String remove(Object key) {
            return this.props.remove(key);
        }

        @Override
        public int size() {
            return this.props.size();
        }

        @Override
        public Collection<String> values() {
            return this.props.values();
        }

        public String toString() {
            String name = this.getName();
            return Ini.DEFAULT_SECTION_NAME.equals(name) ? "<default>" : name;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Section)) {
                return false;
            }
            Section other = (Section)obj;
            return this.getName().equals(other.getName()) && this.props.equals(other.props);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode() * 31 + this.props.hashCode();
        }
    }
}

