/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.lexer;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.text.lexer.BaseToken;
import com.jn.langx.text.lexer.Lexer;
import com.jn.langx.text.lexer.LexerPosition;
import com.jn.langx.text.lexer.LexerPositionImpl;
import com.jn.langx.text.lexer.Token;
import com.jn.langx.util.Preconditions;

public abstract class AbstractLexer
implements Lexer {
    protected abstract void startInternal(@NonNull CharSequence var1, int var2, int var3, int var4);

    @Override
    public final void start(@NonNull CharSequence buf, int start, int end) {
        Preconditions.checkNotNullArgument(buf, "buf");
        this.startInternal(buf, start, end, 0);
    }

    @Override
    public final void start(@NonNull CharSequence buf) {
        Preconditions.checkNotNullArgument(buf, "buf");
        this.startInternal(buf, 0, buf.length(), 0);
    }

    public Token getToken() {
        return new BaseToken(this.getTokenType(), this.getTokenStart(), this.getTokenEnd(), this.getTokenText());
    }

    @Override
    @NonNull
    public String getTokenText() {
        return this.getBufferSequence().subSequence(this.getTokenStart(), this.getTokenEnd()).toString();
    }

    @Override
    @NonNull
    public LexerPosition getCurrentPosition() {
        int offset = this.getTokenStart();
        int intState = this.getState();
        return new LexerPositionImpl(offset, intState);
    }

    @Override
    public void restore(@NonNull LexerPosition position) {
        Preconditions.checkNotNullArgument(position, "position");
        this.startInternal(this.getBufferSequence(), position.getOffset(), this.getBufferEnd(), position.getState());
    }
}

