/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.lexer;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.text.lexer.Key;
import com.jn.langx.util.Preconditions;

public abstract class ImmutableUserMap {
    public static final ImmutableUserMap EMPTY = new ImmutableUserMap(){

        @Override
        public <T> T get(@NonNull Key<T> key) {
            Preconditions.checkNotNullArgument(key, "key");
            return null;
        }
    };

    private ImmutableUserMap() {
    }

    public final <T> ImmutableUserMap put(@NonNull Key<T> key, T value) {
        Preconditions.checkNotNullArgument(key, "key");
        return new ImmutableUserMapImpl(key, value, this);
    }

    public abstract <T> T get(@NonNull Key<T> var1);

    private static final class ImmutableUserMapImpl<V>
    extends ImmutableUserMap {
        private final Key<V> myKey;
        private final V myValue;
        private final ImmutableUserMap myNext;

        private ImmutableUserMapImpl(Key<V> key, V value, ImmutableUserMap next) {
            this.myKey = key;
            this.myNext = next;
            this.myValue = value;
        }

        @Override
        public <T> T get(@NonNull Key<T> key) {
            Preconditions.checkNotNullArgument(key, "key");
            if (key.equals(this.myKey)) {
                return (T)this.myValue;
            }
            return this.myNext.get(key);
        }
    }
}

