/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.placeholder;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.text.StrTokenizer;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.text.placeholder.PlaceholderParser;
import com.jn.langx.text.placeholder.PlaceholderSubExpressionHandler;
import com.jn.langx.text.properties.PropertiesPlaceholderParser;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.struct.Holder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;

public class PropertyPlaceholderHandler {
    private static final Map<String, String> wellKnownSimplePrefixes = new HashMap<String, String>(4);
    private final String placeholderPrefix;
    private final String placeholderSuffix;
    private final String simplePrefix;
    @Nullable
    private final String expressionSeparator;
    private PlaceholderSubExpressionHandler subExpressionHandler = new DefaultValueSubExpressionHandler();
    private final boolean ignoreUnresolvablePlaceholders;
    private Logger logger = Loggers.getLogger(this.getClass());

    public void setSubExpressionHandler(PlaceholderSubExpressionHandler subExpressionHandler) {
        this.subExpressionHandler = subExpressionHandler;
    }

    public PropertyPlaceholderHandler(String placeholderPrefix, String placeholderSuffix) {
        this(placeholderPrefix, placeholderSuffix, null, true);
    }

    public PropertyPlaceholderHandler(String placeholderPrefix, String placeholderSuffix, @Nullable String expressionSeparator, boolean ignoreUnresolvablePlaceholders) {
        Preconditions.checkNotNull(placeholderPrefix, "'placeholderPrefix' must not be null");
        Preconditions.checkNotNull(placeholderSuffix, "'placeholderSuffix' must not be null");
        this.placeholderPrefix = placeholderPrefix;
        this.placeholderSuffix = placeholderSuffix;
        String simplePrefixForSuffix = wellKnownSimplePrefixes.get(this.placeholderSuffix);
        this.simplePrefix = simplePrefixForSuffix != null && this.placeholderPrefix.endsWith(simplePrefixForSuffix) ? simplePrefixForSuffix : this.placeholderPrefix;
        this.expressionSeparator = expressionSeparator;
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    public String replacePlaceholders(String template, Properties properties) {
        Preconditions.checkNotNull(properties, "'properties' must not be null");
        return this.replacePlaceholders(template, new PropertiesPlaceholderParser(properties));
    }

    public String replacePlaceholders(String template, PlaceholderParser placeholderResolver) {
        Preconditions.checkNotNull(template, "'value' must not be null");
        String ret = this.parseStringValue(template, placeholderResolver, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(ret);
        }
        return ret;
    }

    protected String parseStringValue(String template, PlaceholderParser placeholderResolver, @Nullable Set<String> visitedPlaceholders) {
        int startIndex = template.indexOf(this.placeholderPrefix);
        if (startIndex == -1) {
            return template;
        }
        StringBuilder result = new StringBuilder(template);
        while (startIndex != -1) {
            int endIndex = this.findPlaceholderEndIndex(result, startIndex);
            if (endIndex != -1) {
                String variableValue;
                String placeholder;
                String originalPlaceholder = placeholder = result.substring(startIndex + this.placeholderPrefix.length(), endIndex);
                if (visitedPlaceholders == null) {
                    visitedPlaceholders = new HashSet<String>(4);
                }
                if (!visitedPlaceholders.add(originalPlaceholder)) {
                    throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder("Circular placeholder reference '{}' in property definitions", originalPlaceholder));
                }
                String variable = null;
                String expression = null;
                if (this.expressionSeparator != null) {
                    if (placeholder.contains(this.expressionSeparator)) {
                        StrTokenizer tokenizer = new StrTokenizer(placeholder, true, this.expressionSeparator);
                        StringBuilder variableBuilder = new StringBuilder();
                        StringBuilder expressionBuilder = new StringBuilder();
                        int placeholderPrefixSuffixSum = 0;
                        while (tokenizer.hasNext()) {
                            String token = (String)tokenizer.next();
                            if (Strings.equals(this.expressionSeparator, token) && placeholderPrefixSuffixSum % 2 == 0) {
                                while (tokenizer.hasNext()) {
                                    expressionBuilder.append((String)tokenizer.next());
                                }
                            } else {
                                variableBuilder.append(token);
                            }
                            placeholderPrefixSuffixSum += Strings.countOccurrencesOf(token, this.placeholderPrefix);
                            placeholderPrefixSuffixSum += Strings.countOccurrencesOf(token, this.placeholderSuffix);
                        }
                        variable = variableBuilder.toString();
                        expression = expressionBuilder.toString();
                    } else {
                        variable = placeholder;
                    }
                }
                variable = this.parseStringValue(variable, placeholderResolver, visitedPlaceholders);
                if (Strings.isNotEmpty(expression)) {
                    expression = this.parseStringValue(expression, placeholderResolver, visitedPlaceholders);
                }
                if ((variableValue = placeholderResolver.parse(variable)) != null) {
                    variableValue = this.parseStringValue(variableValue, placeholderResolver, visitedPlaceholders);
                }
                if (Strings.isNotEmpty(expression) && this.subExpressionHandler != null) {
                    Holder<String> propValueHolder = new Holder<String>(variableValue);
                    this.subExpressionHandler.accept(variable, expression, propValueHolder);
                    variableValue = propValueHolder.get();
                }
                if (variableValue != null) {
                    result.replace(startIndex, endIndex + this.placeholderSuffix.length(), variableValue);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Resolved placeholder '{}'", (Object)placeholder);
                    }
                    startIndex = result.indexOf(this.placeholderPrefix, startIndex + variableValue.length());
                } else if (this.ignoreUnresolvablePlaceholders) {
                    startIndex = result.indexOf(this.placeholderPrefix, endIndex + this.placeholderSuffix.length());
                } else {
                    throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder("Could not resolve placeholder '{}' in template: {}", placeholder, template));
                }
                visitedPlaceholders.remove(originalPlaceholder);
                continue;
            }
            startIndex = -1;
        }
        return result.toString();
    }

    private int findPlaceholderEndIndex(CharSequence buf, int startIndex) {
        int index = startIndex + this.placeholderPrefix.length();
        int withinNestedPlaceholder = 0;
        while (index < buf.length()) {
            if (Strings.substringMatch(buf, index, this.placeholderSuffix)) {
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    index += this.placeholderSuffix.length();
                    continue;
                }
                return index;
            }
            if (Strings.substringMatch(buf, index, this.simplePrefix)) {
                ++withinNestedPlaceholder;
                index += this.simplePrefix.length();
                continue;
            }
            ++index;
        }
        return -1;
    }

    static {
        wellKnownSimplePrefixes.put("}", "{");
    }

    private static class DefaultValueSubExpressionHandler
    implements PlaceholderSubExpressionHandler {
        private DefaultValueSubExpressionHandler() {
        }

        @Override
        public void accept(String variable, String expression, Holder<String> variableValueHolder) {
            if (Strings.isEmpty(variableValueHolder.get())) {
                variableValueHolder.set(expression);
            }
        }
    }
}

