/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.sensitive;

import com.jn.langx.Transformer;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.collection.trie.TrieMap;

public class SensitiveWordTransformer
implements Transformer<String, String> {
    @NonNull
    private TrieMap<Transformer<String, String>> trieMap;
    @NonNull
    private Transformer<String, String> commonWordTransformer;

    public SensitiveWordTransformer() {
    }

    public SensitiveWordTransformer(Transformer<String, String> commonWordTransformer) {
    }

    public void addSensitiveWord(String word) {
        this.addSensitiveWord(word, this.commonWordTransformer);
    }

    public void addSensitiveWord(String word, Transformer<String, String> transformer) {
        this.trieMap.put(word, transformer);
    }

    @Override
    public String transform(String input) {
        StringBuilder builder = new StringBuilder(input.length());
        int start = 0;
        while (start < input.length()) {
            int currentIndex = start;
            char ch = input.charAt(currentIndex);
            start = currentIndex + 1;
        }
        return builder.toString();
    }
}

