/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.stringtemplate;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.ThrowableFunction;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.function.Function2;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.RegexpMatcher;
import com.jn.langx.util.regexp.Regexps;
import java.util.regex.Matcher;
import org.slf4j.Logger;

public class StringTemplate {
    public static final Regexp defaultPattern = Regexps.createRegexp("\\{\\d+}");
    private static final Function2<String, Object[], String> defaultValueGetter = new IndexBasedValueGetter();
    private Regexp variableRegexp = defaultPattern;
    private String template;
    private Function2<String, Object[], String> valueGetter = defaultValueGetter;

    public StringTemplate variablePattern(String pattern) {
        if (Emptys.isNotEmpty(pattern)) {
            return this.variablePattern(Regexps.compile(pattern));
        }
        return this;
    }

    public StringTemplate variablePattern(Regexp regexp) {
        if (Emptys.isNotNull(regexp)) {
            this.variableRegexp = regexp;
        }
        return this;
    }

    public StringTemplate using(String template) {
        Preconditions.checkNotNull(template);
        this.template = template;
        return this;
    }

    public StringTemplate with(Function2<String, Object[], String> valueGetter) {
        if (valueGetter != null) {
            this.valueGetter = valueGetter;
        }
        if (this.variableRegexp == defaultPattern) {
            this.valueGetter = defaultValueGetter;
        }
        return this;
    }

    public String format(Object[] args) {
        if (Emptys.isNull(args)) {
            args = new Object[]{};
        }
        RegexpMatcher matcher = this.variableRegexp.matcher(this.template);
        StringBuilder b = new StringBuilder();
        Logger logger = Loggers.getLogger(this.getClass());
        while (matcher.find()) {
            final String matched = matcher.group();
            String value = Throwables.ignoreThrowable(logger, matched, new ThrowableFunction<Object[], String>(){

                @Override
                public String doFun(Object[] args) throws Throwable {
                    return (String)StringTemplate.this.valueGetter.apply(matched, args);
                }
            }, args);
            value = Objs.isNull(value) ? matched : value;
            matcher.appendReplacement(b, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(b);
        return b.toString();
    }

    public static class IndexBasedValueGetter
    implements Function2<String, Object[], String> {
        @Override
        public String apply(String matched, Object[] args) {
            Object object = args[this.getIndex(matched)];
            return Emptys.isNull(object) ? "" : object.toString();
        }

        private int getIndex(String matched) {
            int index;
            String indexString = matched;
            if (matched.startsWith("{") && matched.endsWith("}")) {
                indexString = matched.substring(1, matched.length() - 1);
            }
            if ((index = Integer.parseInt(indexString)) < 0) {
                index = 0;
            }
            return index;
        }
    }
}

