/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.tokenizer;

import com.jn.langx.text.tokenizer.IterableTokenizer;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class AbstractTokenizer<T>
implements IterableTokenizer<T> {
    protected T nextToken;
    private static final int DEFAULT_TOKENIZE_LIST_SIZE = 64;

    protected abstract T getNext();

    @Override
    public T next() {
        if (this.nextToken == null) {
            this.nextToken = this.getNext();
        }
        T result = this.nextToken;
        this.nextToken = null;
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public boolean hasNext() {
        if (this.nextToken == null) {
            this.nextToken = this.getNext();
        }
        return this.nextToken != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T peek() {
        if (this.nextToken == null) {
            this.nextToken = this.getNext();
        }
        if (this.nextToken == null) {
            throw new NoSuchElementException();
        }
        return this.nextToken;
    }

    @Override
    public List<T> tokenize() {
        ArrayList<T> result = new ArrayList<T>(64);
        while (this.hasNext()) {
            result.add(this.next());
        }
        if (result.size() <= 16) {
            result.trimToSize();
        }
        return result;
    }
}

