/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.tokenizer;

import com.jn.langx.io.buffer.CharSequenceBuffer;
import com.jn.langx.text.tokenizer.AbstractTokenizer;
import com.jn.langx.text.tokenizer.TokenFactory;
import com.jn.langx.text.tokenizer.TokenizationException;
import com.jn.langx.util.Preconditions;

public abstract class CommonTokenizer<Token>
extends AbstractTokenizer<Token> {
    protected boolean returnDelimiter;
    private CharSequenceBuffer buffer;
    protected TokenFactory<Token> tokenFactory;

    protected CommonTokenizer(String text, boolean returnDelimiter) {
        Preconditions.checkNotEmpty(text);
        this.buffer = new CharSequenceBuffer(text);
        this.returnDelimiter = returnDelimiter;
    }

    protected final CharSequenceBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    protected final Token getNext() {
        Preconditions.checkNotNull(this.tokenFactory, "the token factory is null");
        boolean hasRemaining = this.buffer.hasRemaining();
        if (hasRemaining) {
            long position = this.buffer.position();
            long[] delimiterPositions = this.findNextDelimiter();
            if (delimiterPositions == null) {
                long regionEnd = this.buffer.limit();
                String region = this.buffer.substring(position, regionEnd);
                Token token = this.tokenFactory.get(region, false);
                Preconditions.checkNotNull(token, "the token is null");
                return token;
            }
            long regionEnd = delimiterPositions[0];
            if (regionEnd == position) {
                if (this.returnDelimiter) {
                    String delimiter = this.getDelimiter(position, delimiterPositions[1]);
                    this.buffer.position(delimiterPositions[1]);
                    this.buffer.mark();
                    Token token = this.tokenFactory.get(delimiter, true);
                    Preconditions.checkNotNull(token, "the delimiter token is null");
                    return token;
                }
                this.buffer.position(delimiterPositions[1]);
                this.buffer.mark();
                return this.getNext();
            }
            if (regionEnd > position) {
                String region = this.buffer.substring(position, regionEnd);
                this.buffer.position(regionEnd);
                this.buffer.mark();
                Token token = this.tokenFactory.get(region, false);
                Preconditions.checkNotNull(token, "the token is null");
                return token;
            }
            throw new TokenizationException("error");
        }
        return null;
    }

    private long[] findNextDelimiter() {
        while (this.buffer.hasRemaining()) {
            char c;
            long position = this.buffer.position();
            String delimiter = this.getIfDelimiterStart(position, c = this.buffer.get());
            if (delimiter == null) continue;
            return new long[]{position, position + (long)delimiter.length()};
        }
        return null;
    }

    protected String getDelimiter(long start, long end) {
        String delimiter = this.buffer.substring(start, end);
        this.buffer.position(end);
        this.buffer.mark();
        return delimiter;
    }

    protected abstract String getIfDelimiterStart(long var1, char var3);
}

